/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api.base;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public abstract class SimpleSidedEnergyContainer
extends SnapshotParticipant<Long> {
    public long amount = 0L;
    private final SideStorage[] sideStorages = new SideStorage[7];

    public SimpleSidedEnergyContainer() {
        for (int i = 0; i < 7; ++i) {
            this.sideStorages[i] = new SideStorage(this, i == 6 ? null : Direction.from3DDataValue((int)i));
        }
    }

    public abstract long getCapacity();

    public abstract long getMaxInsert(@Nullable Direction var1);

    public abstract long getMaxExtract(@Nullable Direction var1);

    public EnergyStorage getSideStorage(@Nullable Direction side) {
        return this.sideStorages[side == null ? 6 : side.get3DDataValue()];
    }

    protected Long createSnapshot() {
        return this.amount;
    }

    protected void readSnapshot(Long snapshot) {
        this.amount = snapshot;
    }

    private class SideStorage
    implements EnergyStorage {
        private final Direction side;
        final /* synthetic */ SimpleSidedEnergyContainer this$0;

        private SideStorage(SimpleSidedEnergyContainer simpleSidedEnergyContainer, Direction side) {
            SimpleSidedEnergyContainer simpleSidedEnergyContainer2 = simpleSidedEnergyContainer;
            Objects.requireNonNull(simpleSidedEnergyContainer2);
            this.this$0 = simpleSidedEnergyContainer2;
            this.side = side;
        }

        @Override
        public boolean supportsInsertion() {
            return this.this$0.getMaxInsert(this.side) > 0L;
        }

        @Override
        public long insert(long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notNegative((long)maxAmount);
            long inserted = Math.min(this.this$0.getMaxInsert(this.side), Math.min(maxAmount, this.getCapacity() - this.this$0.amount));
            if (inserted > 0L) {
                this.this$0.updateSnapshots(transaction);
                this.this$0.amount += inserted;
                return inserted;
            }
            return 0L;
        }

        @Override
        public boolean supportsExtraction() {
            return this.this$0.getMaxExtract(this.side) > 0L;
        }

        @Override
        public long extract(long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notNegative((long)maxAmount);
            long extracted = Math.min(this.this$0.getMaxExtract(this.side), Math.min(maxAmount, this.this$0.amount));
            if (extracted > 0L) {
                this.this$0.updateSnapshots(transaction);
                this.this$0.amount -= extracted;
                return extracted;
            }
            return 0L;
        }

        @Override
        public long getAmount() {
            return this.this$0.amount;
        }

        @Override
        public long getCapacity() {
            return this.this$0.getCapacity();
        }
    }
}

