/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api.base;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.ItemStack;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.impl.SimpleItemEnergyStorageImpl;

public interface SimpleEnergyItem {
    public static EnergyStorage createStorage(ContainerItemContext ctx, long capacity, long maxInsert, long maxExtract) {
        return SimpleItemEnergyStorageImpl.createSimpleStorage(ctx, capacity, maxInsert, maxExtract);
    }

    public long getEnergyCapacity(ItemStack var1);

    public long getEnergyMaxInput(ItemStack var1);

    public long getEnergyMaxOutput(ItemStack var1);

    default public long getStoredEnergy(ItemStack stack) {
        return SimpleEnergyItem.getStoredEnergyUnchecked(stack);
    }

    default public void setStoredEnergy(ItemStack stack, long newAmount) {
        SimpleEnergyItem.setStoredEnergyUnchecked(stack, newAmount);
    }

    default public boolean tryUseEnergy(ItemStack stack, long amount) {
        if (stack.getCount() != 1) {
            throw new IllegalArgumentException("Invalid count: " + stack.getCount());
        }
        long newAmount = this.getStoredEnergy(stack) - amount;
        if (newAmount < 0L) {
            return false;
        }
        this.setStoredEnergy(stack, newAmount);
        return true;
    }

    public static long getStoredEnergyUnchecked(ItemStack stack) {
        return (Long)stack.getOrDefault(EnergyStorage.ENERGY_COMPONENT, (Object)0L);
    }

    public static long getStoredEnergyUnchecked(ItemVariant variant) {
        return SimpleEnergyItem.getStoredEnergyUnchecked(variant.getComponents());
    }

    public static long getStoredEnergyUnchecked(DataComponentMap components) {
        return (Long)components.getOrDefault(EnergyStorage.ENERGY_COMPONENT, (Object)0L);
    }

    public static void setStoredEnergyUnchecked(ItemStack stack, long newAmount) {
        if (newAmount <= 0L) {
            stack.remove(EnergyStorage.ENERGY_COMPONENT);
        } else {
            stack.set(EnergyStorage.ENERGY_COMPONENT, (Object)newAmount);
        }
    }
}

