/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.MinSdkVersionException;
import com.android.apksigner.HexEncoding;
import com.android.apksigner.OptionsParser;
import com.android.apksigner.PasswordRetriever;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class ApkSignerTool {
    private static final String VERSION = "0.8";
    private static final String HELP_PAGE_GENERAL = "help.txt";
    private static final String HELP_PAGE_SIGN = "help_sign.txt";
    private static final String HELP_PAGE_VERIFY = "help_verify.txt";

    public static void main(String[] params) throws Exception {
        if (params.length == 0 || "--help".equals(params[0]) || "-h".equals(params[0])) {
            ApkSignerTool.printUsage(HELP_PAGE_GENERAL);
            return;
        }
        if ("--version".equals(params[0])) {
            System.out.println(VERSION);
            return;
        }
        String cmd = params[0];
        try {
            if ("sign".equals(cmd)) {
                ApkSignerTool.sign(Arrays.copyOfRange(params, 1, params.length));
                return;
            }
            if ("verify".equals(cmd)) {
                ApkSignerTool.verify(Arrays.copyOfRange(params, 1, params.length));
                return;
            }
            if ("help".equals(cmd)) {
                ApkSignerTool.printUsage(HELP_PAGE_GENERAL);
                return;
            }
            if ("version".equals(cmd)) {
                System.out.println(VERSION);
                return;
            }
            throw new ParameterException("Unsupported command: " + cmd + ". See --help for supported commands");
        }
        catch (ParameterException | OptionsParser.OptionsException e) {
            System.err.println(e.getMessage());
            System.exit(1);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private static void sign(String[] params) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void verify(String[] params) throws Exception {
        String signerName;
        ApkVerifier.Result result;
        String optionName;
        if (params.length == 0) {
            ApkSignerTool.printUsage(HELP_PAGE_VERIFY);
            return;
        }
        File inputApk = null;
        int minSdkVersion = 1;
        boolean minSdkVersionSpecified = false;
        int maxSdkVersion = Integer.MAX_VALUE;
        boolean maxSdkVersionSpecified = false;
        boolean printCerts = false;
        boolean verbose = false;
        boolean warningsTreatedAsErrors = false;
        OptionsParser optionsParser = new OptionsParser(params);
        String optionOriginalForm = null;
        while ((optionName = optionsParser.nextOption()) != null) {
            optionOriginalForm = optionsParser.getOptionOriginalForm();
            if ("min-sdk-version".equals(optionName)) {
                minSdkVersion = optionsParser.getRequiredIntValue("Mininimum API Level");
                minSdkVersionSpecified = true;
                continue;
            }
            if ("max-sdk-version".equals(optionName)) {
                maxSdkVersion = optionsParser.getRequiredIntValue("Maximum API Level");
                maxSdkVersionSpecified = true;
                continue;
            }
            if ("print-certs".equals(optionName)) {
                printCerts = optionsParser.getOptionalBooleanValue(true);
                continue;
            }
            if ("v".equals(optionName) || "verbose".equals(optionName)) {
                verbose = optionsParser.getOptionalBooleanValue(true);
                continue;
            }
            if ("Werr".equals(optionName)) {
                warningsTreatedAsErrors = optionsParser.getOptionalBooleanValue(true);
                continue;
            }
            if ("help".equals(optionName) || "h".equals(optionName)) {
                ApkSignerTool.printUsage(HELP_PAGE_VERIFY);
                return;
            }
            if ("in".equals(optionName)) {
                inputApk = new File(optionsParser.getRequiredValue("Input APK file"));
                continue;
            }
            throw new ParameterException("Unsupported option: " + optionOriginalForm + ". See --help for supported options.");
        }
        params = optionsParser.getRemainingParams();
        if (inputApk != null) {
            if (params.length > 0) {
                throw new ParameterException("Unexpected parameter(s) after " + optionOriginalForm + ": " + params[0]);
            }
        } else {
            if (params.length < 1) {
                throw new ParameterException("Missing APK");
            }
            if (params.length > 1) {
                throw new ParameterException("Unexpected parameter(s) after APK (" + params[1] + ")");
            }
            inputApk = new File(params[0]);
        }
        if (minSdkVersionSpecified && maxSdkVersionSpecified && minSdkVersion > maxSdkVersion) {
            throw new ParameterException("Min API Level (" + minSdkVersion + ") > max API Level (" + maxSdkVersion + ")");
        }
        ApkVerifier.Builder apkVerifierBuilder = new ApkVerifier.Builder(inputApk);
        if (minSdkVersionSpecified) {
            apkVerifierBuilder.setMinCheckedPlatformVersion(minSdkVersion);
        }
        if (maxSdkVersionSpecified) {
            apkVerifierBuilder.setMaxCheckedPlatformVersion(maxSdkVersion);
        }
        ApkVerifier apkVerifier = apkVerifierBuilder.build();
        try {
            result = apkVerifier.verify();
        }
        catch (MinSdkVersionException e) {
            String msg = e.getMessage();
            if (!msg.endsWith(".")) {
                msg = msg + '.';
            }
            throw new MinSdkVersionException("Failed to determine APK's minimum supported platform version. Use --min-sdk-version to override", e);
        }
        boolean verified = result.isVerified();
        boolean warningsEncountered = false;
        if (verified) {
            List<X509Certificate> signerCerts = result.getSignerCertificates();
            if (verbose) {
                System.out.println("Verifies");
                System.out.println("Verified using v1 scheme (JAR signing): " + result.isVerifiedUsingV1Scheme());
                System.out.println("Verified using v2 scheme (APK Signature Scheme v2): " + result.isVerifiedUsingV2Scheme());
                System.out.println("Number of signers: " + signerCerts.size());
            }
            if (printCerts) {
                int signerNumber = 0;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                Iterator iterator = signerCerts.iterator();
                while (iterator.hasNext()) {
                    DSAParams dsaParams;
                    X509Certificate signerCert = (X509Certificate)iterator.next();
                    System.out.println("Signer #" + ++signerNumber + " certificate DN: " + signerCert.getSubjectDN());
                    byte[] encodedCert = signerCert.getEncoded();
                    System.out.println("Signer #" + signerNumber + " certificate SHA-256 digest: " + HexEncoding.encode(messageDigest.digest(encodedCert)));
                    System.out.println("Signer #" + signerNumber + " certificate SHA-1 digest: " + HexEncoding.encode(sha1.digest(encodedCert)));
                    System.out.println("Signer #" + signerNumber + " certificate MD5 digest: " + HexEncoding.encode(md5.digest(encodedCert)));
                    if (!verbose) continue;
                    PublicKey publicKey = signerCert.getPublicKey();
                    System.out.println("Signer #" + signerNumber + " key algorithm: " + publicKey.getAlgorithm());
                    int keySize = -1;
                    if (publicKey instanceof RSAKey) {
                        keySize = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
                    } else if (publicKey instanceof ECKey) {
                        keySize = ((ECKey)((Object)publicKey)).getParams().getOrder().bitLength();
                    } else if (publicKey instanceof DSAKey && (dsaParams = ((DSAKey)((Object)publicKey)).getParams()) != null) {
                        keySize = dsaParams.getP().bitLength();
                    }
                    System.out.println("Signer #" + signerNumber + " key size (bits): " + (keySize != -1 ? String.valueOf(keySize) : "n/a"));
                    byte[] encodedKey = publicKey.getEncoded();
                    System.out.println("Signer #" + signerNumber + " public key SHA-256 digest: " + HexEncoding.encode(messageDigest.digest(encodedKey)));
                    System.out.println("Signer #" + signerNumber + " public key SHA-1 digest: " + HexEncoding.encode(sha1.digest(encodedKey)));
                    System.out.println("Signer #" + signerNumber + " public key MD5 digest: " + HexEncoding.encode(md5.digest(encodedKey)));
                }
            }
        } else {
            System.err.println("DOES NOT VERIFY");
        }
        for (ApkVerifier.IssueWithParams error : result.getErrors()) {
            System.err.println("ERROR: " + error);
        }
        PrintStream warningsOut = warningsTreatedAsErrors ? System.err : System.out;
        for (ApkVerifier.IssueWithParams issueWithParams : result.getWarnings()) {
            warningsEncountered = true;
            warningsOut.println("WARNING: " + issueWithParams);
        }
        for (ApkVerifier.Result.V1SchemeSignerInfo v1SchemeSignerInfo : result.getV1SchemeSigners()) {
            signerName = v1SchemeSignerInfo.getName();
            for (ApkVerifier.IssueWithParams error : v1SchemeSignerInfo.getErrors()) {
                System.err.println("ERROR: JAR signer " + signerName + ": " + error);
            }
            for (ApkVerifier.IssueWithParams warning : v1SchemeSignerInfo.getWarnings()) {
                warningsEncountered = true;
                warningsOut.println("WARNING: JAR signer " + signerName + ": " + warning);
            }
        }
        for (ApkVerifier.Result.V2SchemeSignerInfo v2SchemeSignerInfo : result.getV2SchemeSigners()) {
            signerName = "signer #" + (v2SchemeSignerInfo.getIndex() + 1);
            for (ApkVerifier.IssueWithParams error : v2SchemeSignerInfo.getErrors()) {
                System.err.println("ERROR: APK Signature Scheme v2 " + signerName + ": " + error);
            }
            for (ApkVerifier.IssueWithParams warning : v2SchemeSignerInfo.getWarnings()) {
                warningsEncountered = true;
                warningsOut.println("WARNING: APK Signature Scheme v2 " + signerName + ": " + warning);
            }
        }
        if (!verified) {
            System.exit(1);
            return;
        }
        if (warningsTreatedAsErrors && warningsEncountered) {
            System.exit(1);
            return;
        }
    }

    private static void printUsage(String page) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(ApkSignerTool.class.getResourceAsStream(page), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + page + " resource");
        }
    }

    private static byte[] readFully(File file) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(file);){
            ApkSignerTool.drain(in, result);
        }
        return result.toByteArray();
    }

    private static void drain(InputStream in, OutputStream out) throws IOException {
        int chunkSize;
        byte[] buf = new byte[65536];
        while ((chunkSize = in.read(buf)) != -1) {
            out.write(buf, 0, chunkSize);
        }
    }

    private static class ParameterException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ParameterException(String message) {
            super(message);
        }
    }

    private static class SignerParams {
        String name;
        String keystoreFile;
        String keystoreKeyAlias;
        String keystorePasswordSpec;
        String keyPasswordSpec;
        Charset passwordCharset;
        String keystoreType;
        String keystoreProviderName;
        String keystoreProviderClass;
        String keystoreProviderArg;
        String keyFile;
        String certFile;
        String v1SigFileBasename;
        PrivateKey privateKey;
        List<X509Certificate> certs;

        private SignerParams() {
        }

        private boolean isEmpty() {
            return this.name == null && this.keystoreFile == null && this.keystoreKeyAlias == null && this.keystorePasswordSpec == null && this.keyPasswordSpec == null && this.passwordCharset == null && this.keystoreType == null && this.keystoreProviderName == null && this.keystoreProviderClass == null && this.keystoreProviderArg == null && this.keyFile == null && this.certFile == null && this.v1SigFileBasename == null && this.privateKey == null && this.certs == null;
        }

        private void loadPrivateKeyAndCerts(PasswordRetriever passwordRetriever) throws Exception {
            if (this.keystoreFile != null) {
                if (this.keyFile != null) {
                    throw new ParameterException("--ks and --key may not be specified at the same time");
                }
                if (this.certFile != null) {
                    throw new ParameterException("--ks and --cert may not be specified at the same time");
                }
                this.loadPrivateKeyAndCertsFromKeyStore(passwordRetriever);
            } else if (this.keyFile != null) {
                this.loadPrivateKeyAndCertsFromFiles(passwordRetriever);
            } else {
                throw new ParameterException("KeyStore (--ks) or private key file (--key) must be specified");
            }
        }

        private void loadPrivateKeyAndCertsFromKeyStore(PasswordRetriever passwordRetriever) throws Exception {
            Charset[] charsetArray;
            String keystorePasswordSpec;
            KeyStore ks;
            String ksType;
            if (this.keystoreFile == null) {
                throw new ParameterException("KeyStore (--ks) must be specified");
            }
            String string = ksType = this.keystoreType != null ? this.keystoreType : KeyStore.getDefaultType();
            if (this.keystoreProviderName != null) {
                ks = KeyStore.getInstance(ksType, this.keystoreProviderName);
            } else if (this.keystoreProviderClass != null) {
                Class<?> ksProviderClass = Class.forName(this.keystoreProviderClass);
                if (!Provider.class.isAssignableFrom(ksProviderClass)) {
                    throw new ParameterException("Keystore Provider class " + this.keystoreProviderClass + " not subclass of " + Provider.class.getName());
                }
                Provider ksProvider = this.keystoreProviderArg != null ? (Provider)ksProviderClass.getConstructor(String.class).newInstance(this.keystoreProviderArg) : (Provider)ksProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                ks = KeyStore.getInstance(ksType, ksProvider);
            } else {
                ks = KeyStore.getInstance(ksType);
            }
            String string2 = keystorePasswordSpec = this.keystorePasswordSpec != null ? this.keystorePasswordSpec : "stdin";
            if (this.passwordCharset != null) {
                Charset[] charsetArray2 = new Charset[1];
                charsetArray = charsetArray2;
                charsetArray2[0] = this.passwordCharset;
            } else {
                charsetArray = new Charset[]{};
            }
            Charset[] additionalPasswordEncodings = charsetArray;
            List<char[]> keystorePasswords = passwordRetriever.getPasswords(keystorePasswordSpec, "Keystore password for " + this.name, additionalPasswordEncodings);
            SignerParams.loadKeyStoreFromFile(ks, "NONE".equals(this.keystoreFile) ? null : this.keystoreFile, keystorePasswords);
            String keyAlias = null;
            PrivateKey key = null;
            try {
                Key entryKey;
                if (this.keystoreKeyAlias == null) {
                    Enumeration<String> aliases = ks.aliases();
                    if (aliases != null) {
                        while (aliases.hasMoreElements()) {
                            String entryAlias = aliases.nextElement();
                            if (!ks.isKeyEntry(entryAlias)) continue;
                            keyAlias = entryAlias;
                            if (this.keystoreKeyAlias != null) {
                                throw new ParameterException(this.keystoreFile + " contains multiple key entries. --ks-key-alias option must be used to specify which entry to use.");
                            }
                            this.keystoreKeyAlias = keyAlias;
                        }
                    }
                    if (this.keystoreKeyAlias == null) {
                        throw new ParameterException(this.keystoreFile + " does not contain key entries");
                    }
                }
                if (!ks.isKeyEntry(keyAlias = this.keystoreKeyAlias)) {
                    throw new ParameterException(this.keystoreFile + " entry \"" + keyAlias + "\" does not contain a key");
                }
                if (this.keyPasswordSpec != null) {
                    List<char[]> keyPasswords = passwordRetriever.getPasswords(this.keyPasswordSpec, "Key \"" + keyAlias + "\" password for " + this.name, additionalPasswordEncodings);
                    entryKey = SignerParams.getKeyStoreKey(ks, keyAlias, keyPasswords);
                } else {
                    try {
                        entryKey = SignerParams.getKeyStoreKey(ks, keyAlias, keystorePasswords);
                    }
                    catch (UnrecoverableKeyException expected) {
                        List<char[]> keyPasswords = passwordRetriever.getPasswords("stdin", "Key \"" + keyAlias + "\" password for " + this.name, additionalPasswordEncodings);
                        entryKey = SignerParams.getKeyStoreKey(ks, keyAlias, keyPasswords);
                    }
                }
                if (entryKey == null) {
                    throw new ParameterException(this.keystoreFile + " entry \"" + keyAlias + "\" does not contain a key");
                }
                if (!(entryKey instanceof PrivateKey)) {
                    throw new ParameterException(this.keystoreFile + " entry \"" + keyAlias + "\" does not contain a private key. It contains a key of algorithm: " + entryKey.getAlgorithm());
                }
                key = (PrivateKey)entryKey;
            }
            catch (UnrecoverableKeyException e) {
                throw new IOException("Failed to obtain key with alias \"" + keyAlias + "\" from " + this.keystoreFile + ". Wrong password?", e);
            }
            this.privateKey = key;
            Certificate[] certChain = ks.getCertificateChain(keyAlias);
            if (certChain == null || certChain.length == 0) {
                throw new ParameterException(this.keystoreFile + " entry \"" + keyAlias + "\" does not contain certificates");
            }
            this.certs = new ArrayList<X509Certificate>(certChain.length);
            for (Certificate cert : certChain) {
                this.certs.add((X509Certificate)cert);
            }
        }

        private static void loadKeyStoreFromFile(KeyStore ks, String file, List<char[]> passwords) throws Exception {
            Exception lastFailure = null;
            for (char[] password : passwords) {
                try {
                    if (file != null) {
                        try (FileInputStream in = new FileInputStream(file);){
                            ks.load(in, password);
                        }
                    } else {
                        ks.load(null, password);
                    }
                    return;
                }
                catch (Exception e) {
                    lastFailure = e;
                }
            }
            if (lastFailure == null) {
                throw new RuntimeException("No keystore passwords");
            }
            throw lastFailure;
        }

        private static Key getKeyStoreKey(KeyStore ks, String keyAlias, List<char[]> passwords) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
            UnrecoverableKeyException lastFailure = null;
            for (char[] password : passwords) {
                try {
                    return ks.getKey(keyAlias, password);
                }
                catch (UnrecoverableKeyException e) {
                    lastFailure = e;
                }
            }
            if (lastFailure == null) {
                throw new RuntimeException("No key passwords");
            }
            throw lastFailure;
        }

        private void loadPrivateKeyAndCertsFromFiles(PasswordRetriever passwordRetriver) throws Exception {
            Collection<? extends Certificate> certs;
            PKCS8EncodedKeySpec keySpec;
            if (this.keyFile == null) {
                throw new ParameterException("Private key file (--key) must be specified");
            }
            if (this.certFile == null) {
                throw new ParameterException("Certificate file (--cert) must be specified");
            }
            byte[] privateKeyBlob = ApkSignerTool.readFully(new File(this.keyFile));
            try {
                Charset[] charsetArray;
                String passwordSpec;
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(privateKeyBlob);
                String string = passwordSpec = this.keyPasswordSpec != null ? this.keyPasswordSpec : "stdin";
                if (this.passwordCharset != null) {
                    Charset[] charsetArray2 = new Charset[1];
                    charsetArray = charsetArray2;
                    charsetArray2[0] = this.passwordCharset;
                } else {
                    charsetArray = new Charset[]{};
                }
                Charset[] additionalPasswordEncodings = charsetArray;
                List<char[]> list = passwordRetriver.getPasswords(passwordSpec, "Private key password for " + this.name, additionalPasswordEncodings);
                keySpec = SignerParams.decryptPkcs8EncodedKey(encryptedPrivateKeyInfo, list);
            }
            catch (IOException e) {
                if (this.keyPasswordSpec == null) {
                    keySpec = new PKCS8EncodedKeySpec(privateKeyBlob);
                }
                throw new InvalidKeySpecException("Failed to parse encrypted private key blob " + this.keyFile, e);
            }
            try {
                this.privateKey = SignerParams.loadPkcs8EncodedPrivateKey(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeySpecException("Failed to load PKCS #8 encoded private key from " + this.keyFile, e);
            }
            FileInputStream in = new FileInputStream(this.certFile);
            Object object = null;
            try {
                certs = CertificateFactory.getInstance("X.509").generateCertificates(in);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                SignerParams.$closeResource((Throwable)object, in);
            }
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(certs.size());
            for (Certificate certificate : certs) {
                certList.add((X509Certificate)certificate);
            }
            this.certs = certList;
        }

        private static PKCS8EncodedKeySpec decryptPkcs8EncodedKey(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, List<char[]> passwords) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
            InvalidKeySpecException lastKeySpecException = null;
            InvalidKeyException lastKeyException = null;
            for (char[] password : passwords) {
                PBEKeySpec decryptionKeySpec = new PBEKeySpec(password);
                try {
                    SecretKey decryptionKey = keyFactory.generateSecret(decryptionKeySpec);
                    return encryptedPrivateKeyInfo.getKeySpec(decryptionKey);
                }
                catch (InvalidKeySpecException e) {
                    lastKeySpecException = e;
                }
                catch (InvalidKeyException e) {
                    lastKeyException = e;
                }
            }
            if (lastKeyException == null && lastKeySpecException == null) {
                throw new RuntimeException("No passwords");
            }
            if (lastKeyException != null) {
                throw lastKeyException;
            }
            throw lastKeySpecException;
        }

        private static PrivateKey loadPkcs8EncodedPrivateKey(PKCS8EncodedKeySpec spec) throws InvalidKeySpecException, NoSuchAlgorithmException {
            try {
                return KeyFactory.getInstance("RSA").generatePrivate(spec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                try {
                    return KeyFactory.getInstance("EC").generatePrivate(spec);
                }
                catch (InvalidKeySpecException invalidKeySpecException2) {
                    try {
                        return KeyFactory.getInstance("DSA").generatePrivate(spec);
                    }
                    catch (InvalidKeySpecException invalidKeySpecException3) {
                        throw new InvalidKeySpecException("Not an RSA, EC, or DSA private key");
                    }
                }
            }
        }

        static /* synthetic */ boolean access$200(SignerParams x0) {
            return x0.isEmpty();
        }

        static /* synthetic */ void access$500(SignerParams x0, PasswordRetriever x1) throws Exception {
            x0.loadPrivateKeyAndCerts(x1);
        }
    }

    private static class ProviderInstallSpec {
        String className;
        String constructorParam;
        Integer position;

        private ProviderInstallSpec() {
        }

        private boolean isEmpty() {
            return this.className == null && this.constructorParam == null && this.position == null;
        }

        private void installProvider() throws Exception {
            if (this.className == null) {
                throw new ParameterException("JCA Provider class name (--provider-class) must be specified");
            }
            Class<?> providerClass = Class.forName(this.className);
            if (!Provider.class.isAssignableFrom(providerClass)) {
                throw new ParameterException("JCA Provider class " + providerClass + " not subclass of " + Provider.class.getName());
            }
            Provider provider = this.constructorParam != null ? (Provider)providerClass.getConstructor(String.class).newInstance(this.constructorParam) : (Provider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.position == null) {
                Security.addProvider(provider);
            } else {
                Security.insertProviderAt(provider, this.position);
            }
        }

        static /* synthetic */ boolean access$300(ProviderInstallSpec x0) {
            return x0.isEmpty();
        }

        static /* synthetic */ void access$400(ProviderInstallSpec x0) throws Exception {
            x0.installProvider();
        }
    }
}

