/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.constantmappers.datadriven.parser.v3;

import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupScope;
import daomephsta.unpick.constantmappers.datadriven.tree.Literal;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetField;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.BinaryExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.CastExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionVisitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.LiteralExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ParenExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.UnaryExpression;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class UnpickV3Writer
extends UnpickV3Visitor {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final String indent;
    private final StringBuilder output = new StringBuilder("unpick v3").append(LINE_SEPARATOR);

    public UnpickV3Writer() {
        this("\t");
    }

    public UnpickV3Writer(String indent) {
        this.indent = indent;
    }

    @Override
    public void visitGroupDefinition(GroupDefinition groupDefinition) {
        this.output.append(LINE_SEPARATOR);
        this.output.append("group ");
        this.writeDataType(groupDefinition.dataType());
        if (groupDefinition.name() != null) {
            this.output.append(" ").append(groupDefinition.name());
        }
        this.output.append(LINE_SEPARATOR);
        for (GroupScope scope : groupDefinition.scopes()) {
            this.output.append(this.indent);
            this.writeGroupScope(scope);
            this.output.append(LINE_SEPARATOR);
        }
        if (groupDefinition.flags()) {
            this.output.append(this.indent).append("@flags").append(LINE_SEPARATOR);
        }
        if (groupDefinition.strict()) {
            this.output.append(this.indent).append("@strict").append(LINE_SEPARATOR);
        }
        if (groupDefinition.format() != null) {
            this.output.append(this.indent).append("@format ");
            this.writeLowerCaseEnum(groupDefinition.format());
            this.output.append(LINE_SEPARATOR);
        }
        for (Expression constant : groupDefinition.constants()) {
            this.output.append(this.indent);
            constant.accept(new ExpressionWriter());
            this.output.append(LINE_SEPARATOR);
        }
    }

    /*
     * Loose catch block
     */
    private void writeGroupScope(GroupScope scope) {
        StringBuilder stringBuilder;
        block11: {
            this.output.append("@scope ");
            GroupScope groupScope = scope;
            Objects.requireNonNull(groupScope);
            GroupScope groupScope2 = groupScope;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupScope.Package.class, GroupScope.Class.class, GroupScope.Method.class}, (Object)groupScope2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Object object2;
                    GroupScope.Package package_ = (GroupScope.Package)groupScope2;
                    Object packageName = object2 = package_.packageName();
                    stringBuilder = this.output.append("package ").append((String)packageName);
                    break;
                }
                case 1: {
                    Object object;
                    Object object2 = (GroupScope.Class)groupScope2;
                    Object className = object = ((GroupScope.Class)object2).className();
                    stringBuilder = this.output.append("class ").append((String)className);
                    break;
                }
                case 2: {
                    String string;
                    Object object = (GroupScope.Method)groupScope2;
                    String className = string = ((GroupScope.Method)object).className();
                    String methodName = string = ((GroupScope.Method)object).methodName();
                    String methodDesc = string = ((GroupScope.Method)object).methodDesc();
                    stringBuilder = this.output.append("method ").append(className).append(" ").append(methodName).append(" ").append(methodDesc);
                }
            }
            break block11;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        StringBuilder ignored = stringBuilder;
    }

    @Override
    public void visitTargetField(TargetField targetField) {
        this.output.append(LINE_SEPARATOR).append("target_field ").append(targetField.className()).append(" ").append(targetField.fieldName()).append(" ").append(targetField.fieldDesc()).append(" ").append(targetField.groupName()).append(LINE_SEPARATOR);
    }

    @Override
    public void visitTargetMethod(TargetMethod targetMethod) {
        this.output.append(LINE_SEPARATOR).append("target_method ").append(targetMethod.className()).append(" ").append(targetMethod.methodName()).append(" ").append(targetMethod.methodDesc()).append(LINE_SEPARATOR);
        ArrayList<Map.Entry<Integer, String>> paramGroups = new ArrayList<Map.Entry<Integer, String>>(targetMethod.paramGroups().entrySet());
        paramGroups.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : paramGroups) {
            this.output.append(this.indent).append("param ").append(entry.getKey()).append(" ").append((String)entry.getValue()).append(LINE_SEPARATOR);
        }
        if (targetMethod.returnGroup() != null) {
            this.output.append(this.indent).append("return ").append(targetMethod.returnGroup()).append(LINE_SEPARATOR);
        }
    }

    private void writeRadixPrefix(int radix) {
        switch (radix) {
            case 10: {
                break;
            }
            case 16: {
                this.output.append("0x");
                break;
            }
            case 8: {
                this.output.append("0");
                break;
            }
            case 2: {
                this.output.append("0b");
                break;
            }
            default: {
                throw new AssertionError((Object)("Illegal radix: " + radix));
            }
        }
    }

    private void writeDataType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                this.output.append("String");
                break;
            }
            case CLASS: {
                this.output.append("Class");
                break;
            }
            default: {
                this.writeLowerCaseEnum(dataType);
            }
        }
    }

    private void writeLowerCaseEnum(Enum<?> enumValue) {
        this.output.append(enumValue.name().toLowerCase(Locale.ROOT));
    }

    static String quoteString(String string, char quoteChar) {
        StringBuilder result = new StringBuilder(string.length() + 2).append(quoteChar);
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    result.append("\\b");
                    continue block8;
                }
                case '\t': {
                    result.append("\\t");
                    continue block8;
                }
                case '\n': {
                    result.append("\\n");
                    continue block8;
                }
                case '\f': {
                    result.append("\\f");
                    continue block8;
                }
                case '\r': {
                    result.append("\\r");
                    continue block8;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block8;
                }
                default: {
                    if (c == quoteChar) {
                        result.append("\\").append(c);
                        continue block8;
                    }
                    if (UnpickV3Writer.isPrintable(c)) {
                        result.append(c);
                        continue block8;
                    }
                    if (c <= '\u00ff') {
                        result.append('\\').append(Integer.toOctalString(c));
                        continue block8;
                    }
                    result.append("\\u").append(String.format("%04x", c));
                }
            }
        }
        return result.append(quoteChar).toString();
    }

    private static boolean isPrintable(char ch) {
        return switch (Character.getType(ch)) {
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> true;
            default -> false;
        };
    }

    public String getOutput() {
        return this.output.toString();
    }

    private final class ExpressionWriter
    extends ExpressionVisitor {
        private ExpressionWriter() {
        }

        @Override
        public void visitBinaryExpression(BinaryExpression binaryExpression) {
            binaryExpression.lhs.accept(this);
            String operatorStr = switch (binaryExpression.operator) {
                default -> throw new MatchException(null, null);
                case BinaryExpression.Operator.BIT_OR -> " | ";
                case BinaryExpression.Operator.BIT_XOR -> " ^ ";
                case BinaryExpression.Operator.BIT_AND -> " & ";
                case BinaryExpression.Operator.BIT_SHIFT_LEFT -> " << ";
                case BinaryExpression.Operator.BIT_SHIFT_RIGHT -> " >> ";
                case BinaryExpression.Operator.BIT_SHIFT_RIGHT_UNSIGNED -> " >>> ";
                case BinaryExpression.Operator.ADD -> " + ";
                case BinaryExpression.Operator.SUBTRACT -> " - ";
                case BinaryExpression.Operator.MULTIPLY -> " * ";
                case BinaryExpression.Operator.DIVIDE -> " / ";
                case BinaryExpression.Operator.MODULO -> " % ";
            };
            UnpickV3Writer.this.output.append(operatorStr);
            binaryExpression.rhs.accept(this);
        }

        @Override
        public void visitCastExpression(CastExpression castExpression) {
            UnpickV3Writer.this.output.append('(');
            UnpickV3Writer.this.writeDataType(castExpression.castType);
            UnpickV3Writer.this.output.append(") ");
            castExpression.operand.accept(this);
        }

        @Override
        public void visitFieldExpression(FieldExpression fieldExpression) {
            UnpickV3Writer.this.output.append(fieldExpression.className).append('.');
            if (fieldExpression.fieldName == null) {
                UnpickV3Writer.this.output.append('*');
            } else {
                UnpickV3Writer.this.output.append(fieldExpression.fieldName);
            }
            if (!fieldExpression.isStatic) {
                UnpickV3Writer.this.output.append(":instance");
            }
            if (fieldExpression.fieldType != null) {
                UnpickV3Writer.this.output.append(':');
                UnpickV3Writer.this.writeDataType(fieldExpression.fieldType);
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public void visitLiteralExpression(LiteralExpression literalExpression) {
            StringBuilder stringBuilder;
            block17: {
                Literal literal = literalExpression.literal;
                Objects.requireNonNull(literal);
                Literal literal2 = literal;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Literal.Integer.class, Literal.Long.class, Literal.Float.class, Literal.Double.class, Literal.Character.class, Literal.String.class}, (Object)literal2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        int n2;
                        Literal.Integer integer = (Literal.Integer)literal2;
                        int value = n2 = integer.value();
                        int radix = n2 = integer.radix();
                        UnpickV3Writer.this.writeRadixPrefix(radix);
                        stringBuilder = UnpickV3Writer.this.output.append(Integer.toUnsignedString(value, radix));
                        break;
                    }
                    case 1: {
                        int n3;
                        long l;
                        Literal.Long longVal = (Literal.Long)literal2;
                        long value = l = longVal.value();
                        int radix = n3 = longVal.radix();
                        UnpickV3Writer.this.writeRadixPrefix(radix);
                        stringBuilder = UnpickV3Writer.this.output.append(Long.toUnsignedString(value, radix)).append('L');
                        break;
                    }
                    case 2: {
                        float f;
                        Literal.Float float_ = (Literal.Float)literal2;
                        float value = f = float_.value();
                        stringBuilder = UnpickV3Writer.this.output.append(value).append('F');
                        break;
                    }
                    case 3: {
                        double d;
                        Literal.Double double_ = (Literal.Double)literal2;
                        double value = d = double_.value();
                        stringBuilder = UnpickV3Writer.this.output.append(value);
                        break;
                    }
                    case 4: {
                        char c;
                        Literal.Character character = (Literal.Character)literal2;
                        char value = c = character.value();
                        stringBuilder = UnpickV3Writer.this.output.append(UnpickV3Writer.quoteString(String.valueOf(value), '\''));
                        break;
                    }
                    case 5: {
                        String string;
                        Literal.String string2 = (Literal.String)literal2;
                        String value = string = string2.value();
                        stringBuilder = UnpickV3Writer.this.output.append(UnpickV3Writer.quoteString(value, '\"'));
                    }
                }
                break block17;
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            StringBuilder ignored = stringBuilder;
        }

        @Override
        public void visitParenExpression(ParenExpression parenExpression) {
            UnpickV3Writer.this.output.append('(');
            parenExpression.expression.accept(this);
            UnpickV3Writer.this.output.append(')');
        }

        @Override
        public void visitUnaryExpression(UnaryExpression unaryExpression) {
            char operatorChar = switch (unaryExpression.operator) {
                default -> throw new MatchException(null, null);
                case UnaryExpression.Operator.NEGATE -> '-';
                case UnaryExpression.Operator.BIT_NOT -> '~';
            };
            UnpickV3Writer.this.output.append(operatorChar);
            unaryExpression.operand.accept(this);
        }
    }
}

