/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.constantmappers.datadriven.parser.v2;

import daomephsta.unpick.constantmappers.datadriven.parser.MemberKey;
import daomephsta.unpick.constantmappers.datadriven.parser.v2.UnpickV2Reader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnpickV2Remapper
implements UnpickV2Reader.Visitor {
    private static final Pattern OBJECT_SIGNATURE_FINDER = Pattern.compile("L([a-zA-Z0-9$_\\/]+);");
    private final Map<String, String> classMappings;
    private final Map<MemberKey, String> methodMappings;
    private final Map<FieldKey, String> fieldMappings;
    private final UnpickV2Reader.Visitor delegate;

    public UnpickV2Remapper(Map<String, String> classMappings, Map<MemberKey, String> methodMappings, Map<FieldKey, String> fieldMappings, UnpickV2Reader.Visitor delegate) {
        this.classMappings = classMappings;
        this.methodMappings = methodMappings;
        this.fieldMappings = fieldMappings;
        this.delegate = delegate;
    }

    private String remapClass(String name) {
        return this.classMappings.getOrDefault(name, name);
    }

    private String remapMethod(String owner, String name, String descriptor) {
        return this.methodMappings.getOrDefault(new MemberKey(owner, name, descriptor), name);
    }

    private String remapField(String owner, String name) {
        return this.fieldMappings.getOrDefault(new FieldKey(owner, name), name);
    }

    private String remapDescriptor(String descriptor) {
        String remappedDescriptor = descriptor;
        if (descriptor != null) {
            Matcher objectSignatureMatcher = OBJECT_SIGNATURE_FINDER.matcher(descriptor);
            while (objectSignatureMatcher.find()) {
                String objectSignature = objectSignatureMatcher.group(1);
                if (!this.classMappings.containsKey(objectSignature)) continue;
                remappedDescriptor = remappedDescriptor.replace(objectSignature, this.classMappings.get(objectSignature));
            }
        }
        return remappedDescriptor;
    }

    @Override
    public UnpickV2Reader.TargetMethodDefinitionVisitor visitTargetMethodDefinition(String owner, String name, String descriptor) {
        String remappedOwner = this.remapClass(owner);
        String remappedName = this.remapMethod(owner, name, descriptor);
        String remappedDescriptor = this.remapDescriptor(descriptor);
        return this.delegate.visitTargetMethodDefinition(remappedOwner, remappedName, remappedDescriptor);
    }

    @Override
    public void startVisit() {
        this.delegate.startVisit();
    }

    @Override
    public void visitLineNumber(int lineNumber) {
        this.delegate.visitLineNumber(lineNumber);
    }

    @Override
    public void visitSimpleConstantDefinition(String group, String owner, String name, String value, String descriptor) {
        String remappedOwner = this.remapClass(owner);
        String remappedName = this.remapField(owner, name);
        String remappedDescriptor = this.remapDescriptor(descriptor);
        this.delegate.visitSimpleConstantDefinition(group, remappedOwner, remappedName, value, remappedDescriptor);
    }

    @Override
    public void visitFlagConstantDefinition(String group, String owner, String name, String value, String descriptor) {
        String remappedOwner = this.remapClass(owner);
        String remappedName = this.remapField(owner, name);
        String remappedDescriptor = this.remapDescriptor(descriptor);
        this.delegate.visitFlagConstantDefinition(group, remappedOwner, remappedName, value, remappedDescriptor);
    }

    @Override
    public void endVisit() {
        this.delegate.endVisit();
    }

    public record FieldKey(String owner, String name) {
    }
}

