/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.tinyremapper.ConsoleLogger;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.TinyUtils;
import net.fabricmc.tinyremapper.api.TrLogger;

public class Main {
    public static void main(String[] rawArgs) {
        Path input;
        ArrayList<String> args = new ArrayList<String>(rawArgs.length);
        boolean ignoreFieldDesc = false;
        boolean propagatePrivate = false;
        TinyRemapper.LinkedMethodPropagation propagateBridges = TinyRemapper.LinkedMethodPropagation.DISABLED;
        boolean removeFrames = false;
        Set<String> forcePropagation = Collections.emptySet();
        File forcePropagationFile = null;
        HashSet<String> knownIndyBsm = new HashSet<String>();
        File knownIndyBsmFile = null;
        boolean ignoreConflicts = false;
        boolean checkPackageAccess = false;
        boolean fixPackageAccess = false;
        boolean resolveMissing = false;
        boolean rebuildSourceFilenames = false;
        boolean skipLocalVariableMapping = false;
        boolean renameInvalidLocals = false;
        Pattern invalidLvNamePattern = null;
        boolean inferNameFromSameLvIndex = false;
        NonClassCopyMode ncCopyMode = NonClassCopyMode.FIX_META_INF;
        int threads = -1;
        HashMap<String, TinyRemapper.CLIExtensionProvider> providerMap = new HashMap<String, TinyRemapper.CLIExtensionProvider>();
        ArrayList<TinyRemapper.Extension> providedExtensions = new ArrayList<TinyRemapper.Extension>();
        ServiceLoader<TinyRemapper.CLIExtensionProvider> cliProviderLoader = ServiceLoader.load(TinyRemapper.CLIExtensionProvider.class);
        cliProviderLoader.iterator().forEachRemaining(provider -> providerMap.put(provider.name(), (TinyRemapper.CLIExtensionProvider)provider));
        ConsoleLogger logger = new ConsoleLogger();
        block89: for (String arg : rawArgs) {
            if (arg.startsWith("--")) {
                int valueSepPos = arg.indexOf(61);
                String argKey = valueSepPos == -1 ? arg.substring(2) : arg.substring(2, valueSepPos);
                argKey = argKey.toLowerCase(Locale.ROOT);
                block33 : switch (argKey.toLowerCase()) {
                    case "ignorefielddesc": {
                        ignoreFieldDesc = true;
                        break;
                    }
                    case "forcepropagation": {
                        forcePropagationFile = new File(arg.substring(valueSepPos + 1));
                        break;
                    }
                    case "knownindybsm": {
                        knownIndyBsmFile = new File(arg.substring(valueSepPos + 1));
                    }
                    case "propagateprivate": {
                        propagatePrivate = true;
                        break;
                    }
                    case "propagatebridges": {
                        switch (arg.substring(valueSepPos + 1).toLowerCase(Locale.ENGLISH)) {
                            case "disabled": {
                                propagateBridges = TinyRemapper.LinkedMethodPropagation.DISABLED;
                                break block33;
                            }
                            case "enabled": {
                                propagateBridges = TinyRemapper.LinkedMethodPropagation.ENABLED;
                                break block33;
                            }
                            case "compatible": {
                                propagateBridges = TinyRemapper.LinkedMethodPropagation.COMPATIBLE;
                                break block33;
                            }
                        }
                        logger.error("invalid propagateBridges: " + arg.substring(valueSepPos + 1));
                        System.exit(1);
                        break;
                    }
                    case "removeframes": {
                        removeFrames = true;
                        break;
                    }
                    case "ignoreconflicts": {
                        ignoreConflicts = true;
                        break;
                    }
                    case "checkpackageaccess": {
                        checkPackageAccess = true;
                        break;
                    }
                    case "fixpackageaccess": {
                        fixPackageAccess = true;
                        break;
                    }
                    case "resolvemissing": {
                        resolveMissing = true;
                        break;
                    }
                    case "rebuildsourcefilenames": {
                        rebuildSourceFilenames = true;
                        break;
                    }
                    case "skiplocalvariablemapping": {
                        skipLocalVariableMapping = true;
                        break;
                    }
                    case "renameinvalidlocals": {
                        renameInvalidLocals = true;
                        break;
                    }
                    case "invalidlvnamepattern": {
                        invalidLvNamePattern = Pattern.compile(arg.substring(valueSepPos + 1));
                        break;
                    }
                    case "infernamefromsamelvindex": {
                        inferNameFromSameLvIndex = true;
                        break;
                    }
                    case "nonclasscopymode": {
                        switch (arg.substring(valueSepPos + 1).toLowerCase(Locale.ENGLISH)) {
                            case "unchanged": {
                                ncCopyMode = NonClassCopyMode.UNCHANGED;
                                break block33;
                            }
                            case "fixmeta": {
                                ncCopyMode = NonClassCopyMode.FIX_META_INF;
                                break block33;
                            }
                            case "skipmeta": {
                                ncCopyMode = NonClassCopyMode.SKIP_META_INF;
                                break block33;
                            }
                        }
                        logger.error("invalid nonClassCopyMode: " + arg.substring(valueSepPos + 1));
                        System.exit(1);
                        break;
                    }
                    case "threads": {
                        threads = Integer.parseInt(arg.substring(valueSepPos + 1));
                        if (threads > 0) continue block89;
                        logger.error("Thread count must be > 0");
                        System.exit(1);
                        break;
                    }
                    case "mixin": {
                        Main.handleExtension(providerMap, "mixin", providedExtensions);
                        break;
                    }
                    case "ext": 
                    case "extension": {
                        Main.handleExtension(providerMap, arg.substring(valueSepPos + 1), providedExtensions);
                        break;
                    }
                    case "loglevel": {
                        logger.setLevel(TrLogger.Level.valueOf(arg.substring(valueSepPos + 1).toUpperCase(Locale.ENGLISH)));
                        break;
                    }
                    default: {
                        logger.error("invalid argument: " + arg + ".");
                        System.exit(1);
                    }
                }
                continue;
            }
            args.add(arg);
        }
        if (args.size() < 5) {
            logger.error("usage: <input> <output> <mappings> <from> <to> [<classpath>]... [--reverse] [--forcePropagation=<file>] [--propagatePrivate] [--ignoreConflicts]");
            System.exit(1);
        }
        if (!Files.isReadable(input = Paths.get((String)args.get(0), new String[0]))) {
            logger.error("Can't read input file " + input + ".");
            System.exit(1);
        }
        Path output = Paths.get((String)args.get(1), new String[0]);
        Path mappings = Paths.get((String)args.get(2), new String[0]);
        if (!Files.isReadable(mappings) || Files.isDirectory(mappings, new LinkOption[0])) {
            logger.error("Can't read mappings file " + mappings + ".");
            System.exit(1);
        }
        String fromM = (String)args.get(3);
        String toM = (String)args.get(4);
        Path[] classpath = new Path[args.size() - 5];
        for (int i = 0; i < classpath.length; ++i) {
            classpath[i] = Paths.get((String)args.get(i + 5), new String[0]);
            if (Files.isReadable(classpath[i])) continue;
            logger.error("Can't read classpath file " + i + ": " + classpath[i] + ".");
            System.exit(1);
        }
        if (forcePropagationFile != null) {
            forcePropagation = new HashSet();
            if (!forcePropagationFile.canRead()) {
                logger.error("Can't read forcePropagation file " + forcePropagationFile + ".");
                System.exit(1);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(forcePropagationFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    forcePropagation.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (knownIndyBsmFile != null) {
            if (!knownIndyBsmFile.canRead()) {
                logger.error("Can't read knownIndyBsm file " + knownIndyBsmFile + ".");
                System.exit(1);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(knownIndyBsmFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    knownIndyBsm.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        long startTime = System.nanoTime();
        TinyRemapper.Builder builder = TinyRemapper.newRemapper(logger).withMappings(TinyUtils.createTinyMappingProvider(mappings, fromM, toM)).ignoreFieldDesc(ignoreFieldDesc).withForcedPropagation(forcePropagation).withKnownIndyBsm(knownIndyBsm).propagatePrivate(propagatePrivate).propagateBridges(propagateBridges).removeFrames(removeFrames).ignoreConflicts(ignoreConflicts).checkPackageAccess(checkPackageAccess).fixPackageAccess(fixPackageAccess).resolveMissing(resolveMissing).rebuildSourceFilenames(rebuildSourceFilenames).skipLocalVariableMapping(skipLocalVariableMapping).renameInvalidLocals(renameInvalidLocals).invalidLvNamePattern(invalidLvNamePattern).inferNameFromSameLvIndex(inferNameFromSameLvIndex).threads(threads);
        for (TinyRemapper.Extension ext : providedExtensions) {
            ext.attach(builder);
        }
        TinyRemapper remapper = builder.build();
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(output).build();){
            outputConsumer.addNonClassFiles(input, ncCopyMode, remapper);
            remapper.readInputs(input);
            remapper.readClassPath(classpath);
            remapper.apply(outputConsumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            remapper.finish();
        }
        logger.info("Finished after %.2f ms.", (double)(System.nanoTime() - startTime) / 1000000.0);
    }

    private static void handleExtension(Map<String, TinyRemapper.CLIExtensionProvider> providerMap, String extName, List<TinyRemapper.Extension> providedExtensions) {
        TinyRemapper.Extension extension;
        TinyRemapper.CLIExtensionProvider provider = providerMap.get(extName);
        if (provider == null) {
            System.err.println("No such extension: " + extName);
            System.exit(1);
        }
        if ((extension = provider.provideExtension()) != null) {
            providedExtensions.add(extension);
        }
    }
}

