/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Objects;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;

public class ShadowData {
    private final String prefix;

    public static ShadowData from(IAnnotationBinding binding) {
        String prefix = "shadow$";
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            if (!Objects.equals("prefix", pair.getName())) continue;
            prefix = (String)pair.getValue();
        }
        return new ShadowData(prefix);
    }

    public ShadowData(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String prefix(String name) {
        return this.prefix + name;
    }

    public String stripPrefix(String name) {
        if (name.startsWith(this.prefix)) {
            return name.substring(this.prefix.length());
        }
        return name;
    }
}

