/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Objects;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ITypeBinding;

public class MixinData {
    protected final ITypeBinding[] targets;
    protected final String[] privateTargets;

    public static MixinData fetch(ITypeBinding binding) {
        for (IAnnotationBinding annotation : binding.getAnnotations()) {
            if (!Objects.equals("org.spongepowered.asm.mixin.Mixin", annotation.getAnnotationType().getBinaryName())) continue;
            return MixinData.from(annotation);
        }
        return null;
    }

    public static MixinData from(IAnnotationBinding binding) {
        ITypeBinding[] targets = new ITypeBinding[]{};
        String[] privateTargets = new String[]{};
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            int i;
            if (Objects.equals("value", pair.getName())) {
                Object[] targetsTemp = (Object[])pair.getValue();
                targets = new ITypeBinding[targetsTemp.length];
                for (i = 0; i < targetsTemp.length; ++i) {
                    targets[i] = (ITypeBinding)targetsTemp[i];
                }
            }
            if (!Objects.equals("targets", pair.getName())) continue;
            Object[] privateTargetsTemp = (Object[])pair.getValue();
            privateTargets = new String[privateTargetsTemp.length];
            for (i = 0; i < privateTargetsTemp.length; ++i) {
                privateTargets[i] = (String)privateTargetsTemp[i];
            }
        }
        return new MixinData(targets, privateTargets);
    }

    public MixinData(ITypeBinding[] targets, String[] privateTargets) {
        this.targets = targets;
        this.privateTargets = privateTargets;
    }

    public ITypeBinding[] getTargets(Mercury mercury) {
        ITypeBinding[] targets = new ITypeBinding[this.targets.length + this.privateTargets.length];
        System.arraycopy(this.targets, 0, targets, 0, this.targets.length);
        for (int i = 0; i < this.privateTargets.length; ++i) {
            targets[this.targets.length + i] = mercury.createTypeBinding(this.privateTargets[i]).orElse(null);
        }
        return targets;
    }

    public ITypeBinding[] getPublicTargets() {
        return this.targets;
    }

    public String[] getPrivateTargets() {
        return this.privateTargets;
    }
}

