/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.mercury.mixin.annotation.ImplementsData;
import org.cadixdev.mercury.mixin.annotation.InterfaceData;
import org.cadixdev.mercury.mixin.annotation.MixinData;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ITypeBinding;

public class MixinClass
extends MixinData {
    private final ITypeBinding binding;
    private final MappingSet mappings;
    private final Map<String, ITypeBinding> implementsData;
    private ClassMapping<?, ?> mixinMapping;

    public static MixinClass fetch(ITypeBinding declaringClass, MappingSet mappings) {
        MixinData mixinData = MixinData.fetch(declaringClass);
        if (mixinData == null) {
            return null;
        }
        ImplementsData implementsData = ImplementsData.fetch(declaringClass);
        HashMap<String, ITypeBinding> implementsMap = new HashMap<String, ITypeBinding>();
        if (implementsData != null) {
            for (InterfaceData interfaceData : implementsData.getValue()) {
                implementsMap.put(interfaceData.getPrefix().substring(0, interfaceData.getPrefix().length() - 1), interfaceData.getIface());
            }
        }
        return new MixinClass(declaringClass, mappings, mixinData.getPublicTargets(), mixinData.getPrivateTargets(), implementsMap);
    }

    public MixinClass(ITypeBinding binding, MappingSet mappings, ITypeBinding[] targets, String[] privateTargets, Map<String, ITypeBinding> implementsData) {
        super(targets, privateTargets);
        this.binding = binding;
        this.mappings = mappings;
        this.implementsData = implementsData;
    }

    public ITypeBinding getBinding() {
        return this.binding;
    }

    public String[] getTargetNames() {
        String[] targets = new String[this.targets.length + this.privateTargets.length];
        for (int i = 0; i < this.targets.length; ++i) {
            targets[i] = this.targets[i].getBinaryName();
        }
        System.arraycopy(this.privateTargets, 0, targets, this.targets.length, this.privateTargets.length);
        return targets;
    }

    public Map<String, ITypeBinding> getImplementsData() {
        return this.implementsData;
    }

    public ClassMapping<?, ?> getMixinMapping() {
        if (this.mixinMapping != null) {
            return this.mixinMapping;
        }
        this.mixinMapping = this.mappings.getOrCreateClassMapping(this.binding.getBinaryName());
        return this.mixinMapping;
    }

    public void copyFieldMapping(ClassMapping<?, ?> targetParent, FieldSignature mixinSignature, FieldSignature targetSignature, Function<String, String> deobfProcessor) {
        FieldMapping targetField = targetParent.computeFieldMapping(targetSignature).orElse(null);
        if (targetField == null) {
            return;
        }
        FieldMapping mixinField = this.getMixinMapping().computeFieldMapping(mixinSignature).orElseGet(() -> this.getMixinMapping().createFieldMapping(mixinSignature));
        mixinField.setDeobfuscatedName(deobfProcessor.apply(targetField.getDeobfuscatedName()));
    }

    public void copyFieldMapping(ClassMapping<?, ?> targetParent, FieldSignature signature, Function<String, String> deobfProcessor) {
        this.copyFieldMapping(targetParent, signature, signature, deobfProcessor);
    }

    public void copyMethodMapping(ClassMapping<?, ?> targetParent, MethodSignature mixinSignature, MethodSignature targetSignature, Function<String, String> deobfProcessor) {
        MethodMapping targetMethod = targetParent.getMethodMapping(targetSignature).orElse(null);
        if (targetMethod == null) {
            return;
        }
        MethodMapping mixinMethod = this.getMixinMapping().getOrCreateMethodMapping(mixinSignature);
        mixinMethod.setDeobfuscatedName(deobfProcessor.apply(targetMethod.getDeobfuscatedName()));
    }

    public void copyMethodMapping(ClassMapping<?, ?> targetParent, MethodSignature signature, Function<String, String> deobfProcessor) {
        this.copyMethodMapping(targetParent, signature, signature, deobfProcessor);
    }

    public void copyMethodMapping(ClassMapping<?, ?> targetParent, MethodSignature mixinSignature, FieldSignature targetSignature, Function<String, String> deobfProcessor) {
        FieldMapping targetField = targetParent.computeFieldMapping(targetSignature).orElse(null);
        if (targetField == null) {
            return;
        }
        MethodMapping mixinMethod = this.getMixinMapping().getOrCreateMethodMapping(mixinSignature);
        mixinMethod.setDeobfuscatedName(deobfProcessor.apply(targetField.getDeobfuscatedName()));
    }
}

