/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Objects;
import org.cadixdev.mercury.mixin.annotation.InterfaceData;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ITypeBinding;

public class ImplementsData {
    private final InterfaceData[] value;

    public static ImplementsData fetch(ITypeBinding binding) {
        for (IAnnotationBinding annotation : binding.getAnnotations()) {
            if (!Objects.equals("org.spongepowered.asm.mixin.Implements", annotation.getAnnotationType().getBinaryName())) continue;
            return ImplementsData.from(annotation);
        }
        return null;
    }

    public static ImplementsData from(IAnnotationBinding binding) {
        InterfaceData[] value = null;
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            if (!Objects.equals("value", pair.getName())) continue;
            Object[] temp = (Object[])pair.getValue();
            value = new InterfaceData[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                IAnnotationBinding valueBinding = (IAnnotationBinding)temp[i];
                value[i] = InterfaceData.from(valueBinding);
            }
        }
        return new ImplementsData(value);
    }

    public ImplementsData(InterfaceData[] value) {
        this.value = value;
    }

    public InterfaceData[] getValue() {
        return this.value;
    }
}

