/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.lang.reflect.Modifier;
import java.util.Objects;
import org.cadixdev.bombe.type.VoidType;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.mercury.mixin.annotation.AccessorData;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMethodBinding;

public enum AccessorType {
    FIELD_GETTER("get", "is"),
    FIELD_SETTER("set"),
    METHOD_PROXY("call", "invoke"),
    OBJECT_FACTORY("new", "create");

    private final String[] prefixes;

    private AccessorType(String ... prefixes) {
        this.prefixes = prefixes;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public boolean isExpectedPrefix(String prefix) {
        for (String expectedPrefix : this.prefixes) {
            if (!Objects.equals(expectedPrefix, prefix)) continue;
            return true;
        }
        return false;
    }

    public static AccessorType get(boolean isInvoker, IMethodBinding binding, MethodSignature signature, AccessorData data) {
        if (isInvoker) {
            if (Modifier.isStatic(binding.getModifiers()) && (data.getTarget().equals("<init>") || data.getTarget().contains("/") || data.getTarget().contains("."))) {
                return OBJECT_FACTORY;
            }
            return METHOD_PROXY;
        }
        return Objects.equals(VoidType.INSTANCE, signature.getDescriptor().getReturnType()) ? FIELD_SETTER : FIELD_GETTER;
    }
}

