/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Objects;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ITypeBinding;

public class InterfaceData {
    private final ITypeBinding iface;
    private final String prefix;

    public static InterfaceData from(IAnnotationBinding binding) {
        ITypeBinding iface = null;
        String prefix = "";
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            if (Objects.equals("iface", pair.getName())) {
                iface = (ITypeBinding)pair.getValue();
            }
            if (!Objects.equals("prefix", pair.getName())) continue;
            prefix = (String)pair.getValue();
        }
        return new InterfaceData(iface, prefix);
    }

    public InterfaceData(ITypeBinding iface, String prefix) {
        this.iface = iface;
        this.prefix = prefix;
    }

    public ITypeBinding getIface() {
        return this.iface;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

