/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cadixdev.bombe.type.MethodDescriptor;
import org.cadixdev.bombe.type.Type;
import org.cadixdev.bombe.type.TypeReader;

public class InjectTarget {
    public static final Pattern FULL_REF_PATTERN = Pattern.compile("L?([\\w_$/]+)[.;](.*)(\\(.*?\\).+)");
    private final String ownerName;
    private final String targetName;
    private final MethodDescriptor methodDescriptor;
    private final Type fieldType;

    public InjectTarget(String targetName) {
        this.ownerName = null;
        this.targetName = targetName;
        this.methodDescriptor = null;
        this.fieldType = null;
    }

    public InjectTarget(String targetName, MethodDescriptor methodDescriptor) {
        this.ownerName = null;
        this.targetName = targetName;
        this.methodDescriptor = methodDescriptor;
        this.fieldType = null;
    }

    public InjectTarget(String targetName, Type fieldType) {
        this.ownerName = null;
        this.targetName = targetName;
        this.methodDescriptor = null;
        this.fieldType = fieldType;
    }

    public InjectTarget(String ownerName, String targetName, MethodDescriptor methodDescriptor) {
        this.ownerName = ownerName;
        this.targetName = targetName;
        this.methodDescriptor = methodDescriptor;
        this.fieldType = null;
    }

    public static InjectTarget of(String target) {
        Matcher matcher = FULL_REF_PATTERN.matcher(target);
        if (matcher.matches()) {
            return new InjectTarget(matcher.group(1), matcher.group(2), MethodDescriptor.of((String)matcher.group(3)));
        }
        int index = target.indexOf(40);
        if (index >= 0) {
            return new InjectTarget(target.substring(0, index), MethodDescriptor.of((String)target.substring(index)));
        }
        index = target.indexOf(58);
        if (index >= 0) {
            Type fieldType = new TypeReader(target.substring(index + 1)).readType();
            return new InjectTarget(target.substring(0, index), fieldType);
        }
        return new InjectTarget(target);
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Optional<MethodDescriptor> getMethodDescriptor() {
        return Optional.ofNullable(this.methodDescriptor);
    }

    public Optional<Type> getFieldType() {
        return Optional.ofNullable(this.fieldType);
    }

    public String getFullTarget() {
        String full = this.targetName;
        if (this.methodDescriptor != null) {
            full = full + this.methodDescriptor.toString();
        } else if (this.fieldType != null) {
            full = full + ":" + this.fieldType.toString();
        }
        return full;
    }

    public String toString() {
        return "InjectTarget{targetName='" + this.targetName + '\'' + ", methodDescriptor=" + this.methodDescriptor + ", fieldType=" + this.fieldType + '}';
    }
}

