/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.adapter;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class VisitOrderVerifier
extends ForwardingMappingVisitor {
    private final boolean allowConsecutiveDuplicateElementVisits;
    private boolean visitedHeader;
    private boolean shouldVisitHeaderElements;
    private boolean visitedNamespaces;
    private boolean visitedMetadata;
    private boolean visitedContent;
    private boolean shouldVisitContentElements;
    private boolean visitedClass;
    private boolean visitedField;
    private boolean visitedMethod;
    private boolean visitedMethodArg;
    private boolean visitedMethodVar;
    private boolean[] visitedElementContent = new boolean[3];
    private boolean visitedEnd;
    private MappedElementKind lastVisitedElement;
    private boolean visitedLastElement;
    private Map<MappedElementKind, SrcInfo> lastSrcInfo = new HashMap<MappedElementKind, SrcInfo>();

    public VisitOrderVerifier(MappingVisitor next) {
        this(next, false);
    }

    public VisitOrderVerifier(MappingVisitor next, boolean allowConsecutiveDuplicateElementVisits) {
        super(next);
        this.allowConsecutiveDuplicateElementVisits = allowConsecutiveDuplicateElementVisits;
        this.init();
    }

    private void init() {
        this.visitedHeader = false;
        this.shouldVisitHeaderElements = false;
        this.visitedNamespaces = false;
        this.visitedMetadata = false;
        this.visitedContent = false;
        this.shouldVisitContentElements = false;
        this.visitedClass = false;
        this.visitedField = false;
        this.visitedMethod = false;
        this.visitedMethodArg = false;
        this.visitedMethodVar = false;
        this.resetVisitedElementContentDownTo(0);
        this.visitedEnd = false;
        this.lastVisitedElement = null;
        this.visitedLastElement = false;
        this.resetLastSrcInfoDownTo(0);
    }

    @Override
    public void reset() {
        this.init();
        super.reset();
    }

    private void resetVisitedElementContentDownTo(int inclusiveLevel) {
        for (int i = this.visitedElementContent.length - 1; i >= inclusiveLevel; --i) {
            this.visitedElementContent[i] = false;
        }
    }

    private void resetLastSrcInfoDownTo(int inclusiveLevel) {
        for (MappedElementKind kind : MappedElementKind.values()) {
            if (kind.level < inclusiveLevel) continue;
            this.lastSrcInfo.remove((Object)kind);
        }
    }

    @Override
    public boolean visitHeader() throws IOException {
        this.assertHeaderNotVisited();
        this.visitedEnd = false;
        this.visitedHeader = true;
        this.shouldVisitHeaderElements = super.visitHeader();
        return this.shouldVisitHeaderElements;
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        this.assertHeaderVisited();
        this.assertNamespacesNotVisited();
        this.assertMetadataNotVisited();
        this.assertShouldVisitHeaderElements();
        this.visitedNamespaces = true;
        super.visitNamespaces(srcNamespace, dstNamespaces);
    }

    @Override
    public void visitMetadata(String key, @Nullable String value) throws IOException {
        this.assertNamespacesVisited();
        this.assertShouldVisitHeaderElements();
        this.visitedMetadata = true;
        this.visitedClass = false;
        this.visitedField = false;
        this.visitedMethod = false;
        this.visitedMethodArg = false;
        this.visitedMethodVar = false;
        super.visitMetadata(key, value);
    }

    @Override
    public boolean visitContent() throws IOException {
        this.assertHeaderVisited();
        if (this.shouldVisitHeaderElements) {
            this.assertNamespacesVisited();
        }
        this.assertContentNotVisited();
        this.visitedContent = true;
        this.shouldVisitContentElements = super.visitContent();
        return this.shouldVisitContentElements;
    }

    @Override
    public boolean visitClass(String srcName) throws IOException {
        MappedElementKind elementKind = MappedElementKind.CLASS;
        SrcInfo srcInfo = new SrcInfo().srcName(srcName);
        this.assertContentVisited();
        this.assertShouldVisitContentElements();
        this.assertLastElementContentVisited();
        this.resetLastSrcInfoDownTo(elementKind.level);
        this.assertNewSrcInfo(elementKind, srcInfo);
        this.visitedClass = true;
        this.visitedField = false;
        this.visitedMethod = false;
        this.visitedMethodArg = false;
        this.visitedMethodVar = false;
        this.lastVisitedElement = elementKind;
        this.lastSrcInfo.put(elementKind, srcInfo);
        this.resetVisitedElementContentDownTo(elementKind.level);
        this.visitedLastElement = super.visitClass(srcName);
        return this.visitedLastElement;
    }

    @Override
    public boolean visitField(String srcName, @Nullable String srcDesc) throws IOException {
        MappedElementKind elementKind = MappedElementKind.FIELD;
        SrcInfo srcInfo = new SrcInfo().srcName(srcName).srcDesc(srcDesc);
        this.assertClassVisited();
        this.assertLastElementContentVisited();
        this.assertElementContentVisited(elementKind.level - 1);
        this.resetLastSrcInfoDownTo(elementKind.level);
        this.assertNewSrcInfo(elementKind, srcInfo);
        this.visitedField = true;
        this.visitedMethod = false;
        this.visitedMethodArg = false;
        this.visitedMethodVar = false;
        this.lastVisitedElement = elementKind;
        this.lastSrcInfo.put(elementKind, srcInfo);
        this.resetVisitedElementContentDownTo(elementKind.level);
        this.visitedLastElement = super.visitField(srcName, srcDesc);
        return this.visitedLastElement;
    }

    @Override
    public boolean visitMethod(String srcName, @Nullable String srcDesc) throws IOException {
        MappedElementKind elementKind = MappedElementKind.METHOD;
        SrcInfo srcInfo = new SrcInfo().srcName(srcName).srcDesc(srcDesc);
        this.assertClassVisited();
        this.assertLastElementContentVisited();
        this.assertElementContentVisited(elementKind.level - 1);
        this.resetLastSrcInfoDownTo(elementKind.level);
        this.assertNewSrcInfo(elementKind, srcInfo);
        this.visitedField = false;
        this.visitedMethod = true;
        this.visitedMethodArg = false;
        this.visitedMethodVar = false;
        this.lastVisitedElement = elementKind;
        this.lastSrcInfo.put(elementKind, srcInfo);
        this.resetVisitedElementContentDownTo(elementKind.level);
        this.visitedLastElement = super.visitMethod(srcName, srcDesc);
        return this.visitedLastElement;
    }

    @Override
    public boolean visitMethodArg(int argPosition, int lvIndex, @Nullable String srcName) throws IOException {
        MappedElementKind elementKind = MappedElementKind.METHOD_ARG;
        SrcInfo srcInfo = new SrcInfo().argPosition(argPosition).lvIndex(lvIndex).srcName(srcName);
        this.assertFieldNotVisited();
        this.assertMethodVisited();
        this.assertLastElementContentVisited();
        this.assertElementContentVisited(elementKind.level - 1);
        this.resetLastSrcInfoDownTo(elementKind.level);
        this.assertNewSrcInfo(elementKind, srcInfo);
        this.visitedMethodArg = true;
        this.visitedMethodVar = false;
        this.lastVisitedElement = elementKind;
        this.lastSrcInfo.put(elementKind, srcInfo);
        this.resetVisitedElementContentDownTo(elementKind.level);
        this.visitedLastElement = super.visitMethodArg(argPosition, lvIndex, srcName);
        return this.visitedLastElement;
    }

    @Override
    public boolean visitMethodVar(int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName) throws IOException {
        MappedElementKind elementKind = MappedElementKind.METHOD_VAR;
        SrcInfo srcInfo = new SrcInfo().lvtRowIndex(lvtRowIndex).lvIndex(lvIndex).startOpIdx(startOpIdx).endOpIdx(endOpIdx).srcName(srcName);
        this.assertFieldNotVisited();
        this.assertMethodVisited();
        this.assertLastElementContentVisited();
        this.assertElementContentVisited(elementKind.level - 1);
        this.resetLastSrcInfoDownTo(elementKind.level);
        this.assertNewSrcInfo(elementKind, srcInfo);
        this.visitedMethodArg = false;
        this.visitedMethodVar = true;
        this.lastVisitedElement = elementKind;
        this.lastSrcInfo.put(elementKind, srcInfo);
        this.resetVisitedElementContentDownTo(elementKind.level);
        this.visitedLastElement = super.visitMethodVar(lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName);
        return this.visitedLastElement;
    }

    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
        this.assertElementVisited(targetKind);
        this.assertLastVisitedElement(targetKind);
        this.assertElementContentNotVisitedDownTo(targetKind.level + 1);
        super.visitDstName(targetKind, namespace, name);
    }

    @Override
    public void visitDstDesc(MappedElementKind targetKind, int namespace, String desc) throws IOException {
        this.assertElementVisited(targetKind);
        this.assertLastVisitedElement(targetKind);
        this.assertElementContentNotVisitedDownTo(targetKind.level + 1);
        super.visitDstDesc(targetKind, namespace, desc);
    }

    @Override
    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        this.assertElementVisited(targetKind);
        this.assertLastVisitedElement(targetKind);
        this.assertElementContentNotVisitedDownTo(targetKind.level);
        if (targetKind.level > 0) {
            this.assertElementContentVisited(targetKind.level - 1);
        }
        this.visitedElementContent[targetKind.level] = true;
        return super.visitElementContent(targetKind);
    }

    @Override
    public void visitComment(MappedElementKind targetKind, String comment) throws IOException {
        this.assertElementVisited(targetKind);
        this.assertLastElementContentVisited();
        super.visitComment(targetKind, comment);
    }

    @Override
    public boolean visitEnd() throws IOException {
        this.assertContentVisited();
        this.assertLastElementContentVisited();
        this.assertEndNotVisited();
        this.init();
        this.visitedEnd = true;
        return super.visitEnd();
    }

    private void assertHeaderNotVisited() {
        if (this.visitedHeader) {
            throw new IllegalStateException("Header already visited");
        }
    }

    private void assertHeaderVisited() {
        if (!this.visitedHeader) {
            throw new IllegalStateException("Header not visited");
        }
    }

    private void assertNamespacesNotVisited() {
        if (this.visitedNamespaces) {
            throw new IllegalStateException("Namespaces already visited");
        }
    }

    private void assertNamespacesVisited() {
        if (!this.visitedNamespaces) {
            throw new IllegalStateException("Namespaces not visited");
        }
    }

    private void assertMetadataNotVisited() {
        if (this.visitedMetadata) {
            throw new IllegalStateException("Metadata already visited");
        }
    }

    private void assertShouldVisitHeaderElements() {
        if (!this.shouldVisitHeaderElements) {
            throw new IllegalStateException("Header elements were not supposed to be visited");
        }
    }

    private void assertContentNotVisited() {
        if (this.visitedContent) {
            throw new IllegalStateException("Content already visited");
        }
    }

    private void assertContentVisited() {
        if (!this.visitedContent) {
            throw new IllegalStateException("Content not visited");
        }
    }

    private void assertShouldVisitContentElements() {
        if (!this.shouldVisitContentElements) {
            throw new IllegalStateException("Content elements were not supposed to be visited");
        }
    }

    private void assertElementVisited(MappedElementKind kind) {
        if (this.lastVisitedElement.level < kind.level) {
            throw new IllegalStateException("Element not visited");
        }
    }

    private void assertLastVisitedElement(MappedElementKind kind) {
        if (this.lastVisitedElement != kind) {
            throw new IllegalStateException("Last visited element is not " + (Object)((Object)kind));
        }
    }

    private void assertClassVisited() {
        if (!this.visitedClass) {
            throw new IllegalStateException("Class not visited");
        }
    }

    private void assertFieldNotVisited() {
        if (this.visitedField) {
            throw new IllegalStateException("Field already visited");
        }
    }

    private void assertMethodVisited() {
        if (!this.visitedMethod) {
            throw new IllegalStateException("Method not visited");
        }
    }

    private void assertLastElementContentVisited() {
        if (this.visitedLastElement) {
            this.assertElementContentVisited(this.lastVisitedElement.level);
            this.assertElementContentNotVisitedDownTo(this.lastVisitedElement.level + 1);
        }
    }

    private void assertElementContentNotVisitedDownTo(int inclusiveLevel) {
        for (int i = this.visitedElementContent.length - 1; i >= inclusiveLevel; --i) {
            if (!this.visitedElementContent[i]) continue;
            throw new IllegalStateException((Object)((Object)this.lastVisitedElement) + " element content already visited");
        }
    }

    private void assertElementContentVisited(int depth) {
        if (!this.visitedElementContent[depth]) {
            throw new IllegalStateException((Object)((Object)this.lastVisitedElement) + " element content not visited");
        }
    }

    private void assertEndNotVisited() {
        if (this.visitedEnd) {
            throw new IllegalStateException("End already visited");
        }
    }

    private void assertNewSrcInfo(MappedElementKind kind, SrcInfo srcInfo) {
        if (!this.allowConsecutiveDuplicateElementVisits && srcInfo.equals(this.lastSrcInfo.get((Object)kind))) {
            throw new IllegalStateException("Same element visited twice in a row");
        }
    }

    private static class SrcInfo {
        private String srcName;
        private String srcDesc;
        private int argPosition;
        private int lvIndex;
        private int lvtRowIndex;
        private int startOpIdx;
        private int endOpIdx;

        private SrcInfo() {
        }

        SrcInfo srcName(String srcName) {
            this.srcName = srcName;
            return this;
        }

        SrcInfo srcDesc(String srcDesc) {
            this.srcDesc = srcDesc;
            return this;
        }

        SrcInfo argPosition(int argPosition) {
            this.argPosition = argPosition;
            return this;
        }

        SrcInfo lvIndex(int lvIndex) {
            this.lvIndex = lvIndex;
            return this;
        }

        SrcInfo lvtRowIndex(int lvtRowIndex) {
            this.lvtRowIndex = lvtRowIndex;
            return this;
        }

        SrcInfo startOpIdx(int startOpIdx) {
            this.startOpIdx = startOpIdx;
            return this;
        }

        SrcInfo endOpIdx(int endOpIdx) {
            this.endOpIdx = endOpIdx;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof SrcInfo) {
                SrcInfo other = (SrcInfo)o;
                return Objects.equals(this.srcName, other.srcName) && Objects.equals(this.srcDesc, other.srcDesc) && this.argPosition == other.argPosition && this.lvIndex == other.lvIndex && this.lvtRowIndex == other.lvtRowIndex && this.startOpIdx == other.startOpIdx && this.endOpIdx == other.endOpIdx;
            }
            return false;
        }
    }
}

