/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.plugin.bundled.CorsPluginConfig;
import io.javalin.security.RouteRole;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.meta.web.EndpointsV1;
import net.fabricmc.meta.web.EndpointsV2;

public class WebServer {
    public static Javalin javalin;
    public static Gson GSON;

    public static Javalin create() {
        if (javalin != null) {
            javalin.stop();
        }
        javalin = Javalin.create(config -> {
            config.plugins.enableRouteOverview("/", new RouteRole[0]);
            config.showJavalinBanner = false;
            config.plugins.enableCors(cors -> cors.add(CorsPluginConfig::anyHost));
        });
        EndpointsV1.setup();
        EndpointsV2.setup();
        return javalin;
    }

    public static void start() {
        assert (javalin == null);
        WebServer.create().start(5555);
    }

    public static <T> void jsonGet(String route, Supplier<T> supplier) {
        javalin.get(route, ctx -> {
            Object object = supplier.get();
            WebServer.handleJson(ctx, object);
        });
    }

    public static <T> void jsonGet(String route, Function<Context, T> supplier) {
        javalin.get(route, ctx -> {
            Object object = supplier.apply(ctx);
            WebServer.handleJson(ctx, object);
        });
    }

    private static void handleJson(Context ctx, Object object) {
        if (object == null) {
            object = new Object();
            ctx.status(400);
        }
        String response = GSON.toJson(object);
        ctx.contentType("application/json").header("Cache-Control", "public, max-age=60").result(response);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

