/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.web;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fabricmc.meta.utils.LoaderMeta;
import net.fabricmc.meta.web.EndpointsV2;
import org.apache.commons.io.IOUtils;

public class ProfileHandler {
    private static final Executor EXECUTOR = Executors.newFixedThreadPool(2);
    private static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public static void setup() {
        EndpointsV2.fileDownload("client", "json", ProfileHandler::getFileName, ProfileHandler::profileJson);
        EndpointsV2.fileDownload("client", "zip", ProfileHandler::getFileName, ProfileHandler::profileZip);
        EndpointsV2.fileDownload("server", "json", ProfileHandler::getFileName, ProfileHandler::profileJson);
    }

    private static String getFileName(EndpointsV2.ProfileEnvironment env) {
        return String.format("%s.%s", ProfileHandler.getName(env), env.ext());
    }

    private static String getName(EndpointsV2.ProfileEnvironment env) {
        String loaderVersion = env.loader().getVersion();
        if (env.game().version().obfuscated()) {
            return String.format("fabric-loader-%s-%s", loaderVersion, env.game().intermediary().getVersion());
        }
        return String.format("fabric-loader-%s-%s", loaderVersion, env.game().version().id());
    }

    private static CompletableFuture<InputStream> profileJson(EndpointsV2.ProfileEnvironment env) {
        return CompletableFuture.supplyAsync(() -> ProfileHandler.getProfileJsonStream(env), EXECUTOR);
    }

    private static CompletableFuture<InputStream> profileZip(EndpointsV2.ProfileEnvironment env) {
        return ProfileHandler.profileJson(env).thenApply(inputStream -> ProfileHandler.packageZip(env, inputStream));
    }

    private static InputStream packageZip(EndpointsV2.ProfileEnvironment env, InputStream profileJson) {
        String profileName = ProfileHandler.getName(env);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (ZipOutputStream zipStream = new ZipOutputStream(byteArrayOutputStream);){
                zipStream.putNextEntry(new ZipEntry(profileName + "/" + profileName + ".json"));
                IOUtils.copy(profileJson, (OutputStream)zipStream);
                zipStream.closeEntry();
                zipStream.putNextEntry(new ZipEntry(profileName + "/" + profileName + ".jar"));
                zipStream.closeEntry();
            }
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }

    private static InputStream getProfileJsonStream(EndpointsV2.ProfileEnvironment env) {
        JsonObject jsonObject = ProfileHandler.buildProfileJson(env);
        return new ByteArrayInputStream(jsonObject.toString().getBytes());
    }

    private static JsonObject buildProfileJson(EndpointsV2.ProfileEnvironment env) {
        JsonObject launcherMeta = LoaderMeta.getMeta(env.loader());
        String profileName = ProfileHandler.getName(env);
        JsonObject librariesObject = launcherMeta.get("libraries").getAsJsonObject();
        JsonArray libraries = (JsonArray)librariesObject.get("common");
        if (env.game().version().obfuscated()) {
            libraries.add(ProfileHandler.formatLibrary(env.game().intermediary().getMaven(), "https://maven.fabricmc.net/"));
        }
        libraries.add(ProfileHandler.formatLibrary(env.loader().getMaven(), "https://maven.fabricmc.net/"));
        if (librariesObject.has(env.side())) {
            libraries.addAll(librariesObject.get(env.side()).getAsJsonArray());
        }
        String currentTime = ISO_8601.format(new Date());
        JsonObject profile = new JsonObject();
        profile.addProperty("id", profileName);
        profile.addProperty("inheritsFrom", env.game().version().id());
        profile.addProperty("releaseTime", currentTime);
        profile.addProperty("time", currentTime);
        profile.addProperty("type", "release");
        JsonElement mainClassElement = launcherMeta.get("mainClass");
        String mainClass = mainClassElement.isJsonObject() ? mainClassElement.getAsJsonObject().get(env.side()).getAsString() : mainClassElement.getAsString();
        profile.addProperty("mainClass", mainClass);
        JsonObject arguments = new JsonObject();
        arguments.add("game", new JsonArray());
        if (env.side().equals("client")) {
            JsonArray jvmArgs = new JsonArray();
            jvmArgs.add("-DFabricMcEmu= net.minecraft.client.main.Main ");
            arguments.add("jvm", jvmArgs);
        }
        profile.add("arguments", arguments);
        profile.add("libraries", libraries);
        return profile;
    }

    private static JsonObject formatLibrary(String mavenPath, String url2) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", mavenPath);
        jsonObject.addProperty("url", url2);
        return jsonObject;
    }
}

