/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.fabricmc.meta.web.models.BaseVersion;

public class PomParser {
    public String path;
    public String latestVersion = "";
    public List<String> versions = new ArrayList<String>();

    public PomParser(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException, XMLStreamException {
        this.versions.clear();
        URL url2 = URI.create(this.path).toURL();
        URLConnection conn = url2.openConnection();
        conn.setConnectTimeout(3000);
        conn.setReadTimeout(3000);
        try (XMLStreamReader reader = null;){
            reader = XMLInputFactory.newInstance().createXMLStreamReader(conn.getInputStream());
            while (reader.hasNext()) {
                if (reader.next() != 1 || !reader.getLocalName().equals("version")) continue;
                String text = reader.getElementText();
                this.versions.add(text);
            }
        }
        Collections.reverse(this.versions);
        this.latestVersion = this.versions.get(0);
    }

    public <T extends BaseVersion> List<T> getMeta(Function<String, T> function, String prefix) throws IOException, XMLStreamException {
        return this.getMeta(function, prefix, list -> {
            if (!list.isEmpty()) {
                ((BaseVersion)list.get(0)).setStable(true);
            }
        });
    }

    public <T extends BaseVersion> List<T> getMeta(Function<String, T> function, String prefix, StableVersionIdentifier stableIdentifier) throws IOException, XMLStreamException {
        try {
            this.load();
        }
        catch (IOException e) {
            throw new IOException("Failed to load " + this.path, e);
        }
        List list = this.versions.stream().map(version -> prefix + version).map(function).collect(Collectors.toList());
        Path unstableVersionsPath = Paths.get(prefix.replace(":", "_").replace(".", "_").replaceFirst(".$", "") + ".txt", new String[0]);
        if (Files.exists(unstableVersionsPath, new LinkOption[0])) {
            HashSet<String> unstableVersions = new HashSet<String>(Files.readAllLines(unstableVersionsPath));
            for (BaseVersion e : list) {
                if (unstableVersions.contains(e.getVersion())) continue;
                e.setStable(true);
                break;
            }
        } else {
            stableIdentifier.process(list);
        }
        return Collections.unmodifiableList(list);
    }

    public static interface StableVersionIdentifier {
        public void process(List<? extends BaseVersion> var1);
    }
}

