/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Function;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.minecraft.ManifestLocations;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.VersionsManifest;
import net.fabricmc.loom.util.download.DownloadBuilder;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.jspecify.annotations.Nullable;

public final class MinecraftMetadataProvider {
    private final Options options;
    private final Function<String, DownloadBuilder> download;
    private ManifestEntryLocation versionEntry;
    private MinecraftVersionMeta versionMeta;

    private MinecraftMetadataProvider(Options options, Function<String, DownloadBuilder> download) {
        this.options = options;
        this.download = download;
    }

    public static MinecraftMetadataProvider create(ConfigContext configContext) {
        String minecraftVersion = MinecraftMetadataProvider.resolveMinecraftVersion(configContext.project());
        return new MinecraftMetadataProvider(Options.create(minecraftVersion, configContext.project()), configContext.extension()::download);
    }

    private static String resolveMinecraftVersion(Project project) {
        DependencyInfo dependency = DependencyInfo.create(project, "minecraft");
        return dependency.getDependency().getVersion();
    }

    public String getMinecraftVersion() {
        return this.options.minecraftVersion();
    }

    public MinecraftVersionMeta getVersionMeta() {
        try {
            if (this.versionEntry == null) {
                this.versionEntry = this.getVersionEntry();
            }
            if (this.versionMeta == null) {
                this.versionMeta = this.readVersionMeta();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        return this.versionMeta;
    }

    public boolean isUnobfuscated() {
        return this.getVersionMeta().isVersionOrNewer("2025-11-01T00:00:00+00:00") && !this.getVersionMeta().downloads().containsKey("client_mappings");
    }

    private ManifestEntryLocation getVersionEntry() throws IOException {
        if (this.options.customManifestUrl() != null) {
            VersionsManifest.Version customVersion = new VersionsManifest.Version(this.options.minecraftVersion(), this.options.customManifestUrl());
            return new ManifestEntryLocation(null, customVersion);
        }
        ArrayList<ManifestEntrySupplier> suppliers = new ArrayList<ManifestEntrySupplier>();
        for (ManifestLocations.ManifestLocation location : this.options.versionsManifests()) {
            suppliers.add(() -> this.getManifestEntry(location, false));
        }
        for (ManifestLocations.ManifestLocation location : this.options.versionsManifests()) {
            suppliers.add(() -> this.getManifestEntry(location, true));
        }
        for (ManifestEntrySupplier supplier : suppliers) {
            ManifestEntryLocation version = supplier.get();
            if (version == null) continue;
            return version;
        }
        throw new RuntimeException("Failed to find minecraft version: " + this.options.minecraftVersion());
    }

    private @Nullable ManifestEntryLocation getManifestEntry(ManifestLocations.ManifestLocation location, boolean forceDownload) throws IOException {
        Path cacheFile;
        DownloadBuilder builder = this.download.apply(location.url());
        builder = forceDownload ? builder.forceDownload() : builder.defaultCache();
        String versionManifest = builder.downloadString(cacheFile = location.cacheFile(this.options.userCache()));
        VersionsManifest manifest = (VersionsManifest)LoomGradlePlugin.GSON.fromJson(versionManifest, VersionsManifest.class);
        VersionsManifest.Version version = manifest.getVersion(this.options.minecraftVersion());
        if (version != null) {
            return new ManifestEntryLocation(location, version);
        }
        return null;
    }

    private MinecraftVersionMeta readVersionMeta() throws IOException {
        DownloadBuilder builder = this.download.apply(this.versionEntry.entry.url());
        if (this.versionEntry.entry.sha1() != null) {
            builder.sha1(this.versionEntry.entry.sha1());
        } else {
            builder.defaultCache();
        }
        String fileName = this.getVersionMetaFileName();
        Path cacheFile = this.options.workingDir().resolve(fileName);
        String json = builder.downloadString(cacheFile);
        return (MinecraftVersionMeta)LoomGradlePlugin.GSON.fromJson(json, MinecraftVersionMeta.class);
    }

    private String getVersionMetaFileName() {
        if (this.versionEntry.manifest == null) {
            return "minecraft_info_" + Integer.toHexString(this.versionEntry.entry.url().hashCode()) + ".json";
        }
        return this.versionEntry.manifest.name() + "_minecraft_info.json";
    }

    public record Options(String minecraftVersion, ManifestLocations versionsManifests, @Nullable String customManifestUrl, Path userCache, Path workingDir) {
        public static Options create(String minecraftVersion, Project project) {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            Path userCache = extension.getFiles().getUserCache().toPath();
            Path workingDir = MinecraftProvider.minecraftWorkingDirectory(project, minecraftVersion).toPath();
            ManifestLocations manifestLocations = extension.getVersionsManifests();
            Property<String> customMetaUrl = extension.getCustomMinecraftMetadata();
            return new Options(minecraftVersion, manifestLocations, (String)customMetaUrl.getOrNull(), userCache, workingDir);
        }
    }

    private record ManifestEntryLocation(ManifestLocations.ManifestLocation manifest, VersionsManifest.Version entry) {
    }

    @FunctionalInterface
    private static interface ManifestEntrySupplier {
        public ManifestEntryLocation get() throws IOException;
    }
}

