/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.verify;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import net.fabricmc.loom.configuration.providers.minecraft.verify.CertificateChain;
import net.fabricmc.loom.configuration.providers.minecraft.verify.CertificateRevocationList;
import net.fabricmc.loom.configuration.providers.minecraft.verify.JarVerifier;
import net.fabricmc.loom.configuration.providers.minecraft.verify.KnownVersions;
import net.fabricmc.loom.configuration.providers.minecraft.verify.SignatureVerificationFailure;
import net.fabricmc.loom.util.Checksum;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinecraftJarVerification {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinecraftJarVerification.class);
    private final String minecraftVersion;

    @Inject
    protected abstract Project getProject();

    @Inject
    public MinecraftJarVerification(String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    public void verifyClientJar(Path path) throws IOException, SignatureVerificationFailure {
        this.verifyJarSignature(path, KnownJarType.CLIENT);
    }

    public void verifyServerJar(Path path) throws IOException, SignatureVerificationFailure {
        this.verifyJarSignature(path, KnownJarType.SERVER);
    }

    private void verifyJarSignature(Path path, KnownJarType type) throws IOException, SignatureVerificationFailure {
        CertificateChain chain = CertificateChain.getRoot("mojangcs");
        CertificateRevocationList revocationList = CertificateRevocationList.create(this.getProject(), CertificateRevocationList.CSC3_2010);
        try {
            revocationList.verify(chain);
            JarVerifier.verify(path, chain);
        }
        catch (SignatureVerificationFailure e) {
            if (this.isValidKnownVersion(path, this.minecraftVersion, type)) {
                LOGGER.info("Minecraft {} signature verification failed, but is a known version", (Object)path.getFileName());
                return;
            }
            LOGGER.error("Verification of Minecraft {} signature failed: {}", (Object)path.getFileName(), (Object)e.getMessage());
            try {
                Files.delete(path);
            }
            catch (IOException ioe) {
                LOGGER.error("Failed to delete invalid Minecraft jar: {}", (Object)path, (Object)ioe);
            }
            throw e;
        }
    }

    private boolean isValidKnownVersion(Path path, String version, KnownJarType type) throws IOException, SignatureVerificationFailure {
        Map<String, String> knownVersions = type.getKnownVersions();
        String expectedHash = knownVersions.get(version);
        if (expectedHash == null) {
            return false;
        }
        LOGGER.info("Found executed hash ({}) for known version: {}", (Object)expectedHash, (Object)version);
        Checksum.Result hash = Checksum.of(path).sha256();
        if (hash.matchesStr(expectedHash)) {
            LOGGER.info("Minecraft {} hash matches known version", (Object)path.getFileName());
            return true;
        }
        throw new SignatureVerificationFailure("Hash mismatch for known Minecraft version " + version + ": expected " + expectedHash + ", got " + String.valueOf(hash));
    }

    private static enum KnownJarType {
        CLIENT(KnownVersions::client),
        SERVER(KnownVersions::server);

        private final Function<KnownVersions, Map<String, String>> knownVersions;

        private KnownJarType(Function<KnownVersions, Map<String, String>> knownVersions) {
            this.knownVersions = knownVersions;
        }

        private Map<String, String> getKnownVersions() {
            return this.knownVersions.apply(KnownVersions.INSTANCE.get());
        }
    }
}

