/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.IOException;
import java.io.UncheckedIOException;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingSpecBuilderImpl;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsFactory;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Nested;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrateMappingsService
extends Service<Options> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateMappingsService.class);
    private static final ServiceType<Options, MigrateMappingsService> TYPE = new ServiceType<Options, MigrateMappingsService>(Options.class, MigrateMappingsService.class);

    public MigrateMappingsService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public static Provider<Options> createOptions(Project project, Provider<String> targetMappings) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Provider from = project.provider(() -> "intermediary");
        Provider to = project.provider(() -> "named");
        ConfigurableFileCollection classpath = project.getObjects().fileCollection();
        classpath.from(new Object[]{project.getConfigurations().getByName("compileClasspath")});
        classpath.from(new Object[]{extension.getMinecraftJars(MappingsNamespace.INTERMEDIARY)});
        classpath.from(new Object[]{extension.getMinecraftJars(MappingsNamespace.NAMED)});
        return TYPE.create(project, (Action<Options>)((Action)o -> {
            FileCollection targetMappingsFile = MigrateMappingsService.getTargetMappingsFile(project, (String)targetMappings.get());
            o.getSourceMappings().set(MappingsService.createOptionsWithProjectMappings(project, (Provider<String>)from, (Provider<String>)to));
            o.getTargetMappings().set(TinyMappingsService.createOptions(project, targetMappingsFile, "mappings/mappings.tiny"));
            o.getClasspath().from(new Object[]{classpath});
        }));
    }

    public MappingsService getSourceMappingsService() {
        return (MappingsService)this.getServiceFactory().get((MappingsService.Options)((Options)this.getOptions()).getSourceMappings().get());
    }

    public TinyMappingsService getTargetMappingsService() {
        return (TinyMappingsService)this.getServiceFactory().get((TinyMappingsService.Options)((Options)this.getOptions()).getTargetMappings().get());
    }

    public FileCollection getClasspath() {
        return ((Options)this.getOptions()).getClasspath();
    }

    private static FileCollection getTargetMappingsFile(Project project, String mappings) {
        if (mappings == null || mappings.isEmpty()) {
            throw new IllegalArgumentException("No mappings were specified. Use --mappings=\"\" to specify target mappings");
        }
        try {
            if (mappings.startsWith("net.minecraft:mappings:")) {
                if (!mappings.endsWith(":" + LoomGradleExtension.get(project).getMinecraftProvider().minecraftVersion())) {
                    throw new UnsupportedOperationException("Migrating Mojang mappings is currently only supported for the specified minecraft version");
                }
                LayeredMappingsFactory dep = new LayeredMappingsFactory(LayeredMappingSpecBuilderImpl.buildOfficialMojangMappings());
                return project.files(new Object[]{dep.resolve(project).toFile()});
            }
            Dependency dependency = project.getDependencies().create((Object)mappings);
            return project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
        }
        catch (IllegalDependencyNotation ignored) {
            LOGGER.info("Could not locate mappings, presuming V2 Yarn");
            String mavenNotation = "net.fabricmc:yarn:%s:v2".formatted(mappings);
            return project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)mavenNotation)});
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to resolve mappings", e);
        }
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public Property<MappingsService.Options> getSourceMappings();

        @Nested
        public Property<TinyMappingsService.Options> getTargetMappings();

        @Classpath
        public ConfigurableFileCollection getClasspath();
    }
}

