/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.launch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public abstract class GenerateLog4jConfigTask
extends AbstractLoomTask {
    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Inject
    public GenerateLog4jConfigTask() {
        this.getOutputFile().set(this.getExtension().getFiles().getDefaultLog4jConfigFile());
    }

    @TaskAction
    public void run() {
        Path outputFile = ((RegularFile)this.getOutputFile().get()).getAsFile().toPath();
        try (InputStream is = GenerateLog4jConfigTask.class.getClassLoader().getResourceAsStream("log4j2.fabric.xml");){
            Files.deleteIfExists(outputFile);
            Files.copy(is, outputFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate log4j config", e);
        }
    }
}

