/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;

public final class StaticPathWatcher {
    public static final StaticPathWatcher INSTANCE = new StaticPathWatcher();
    private final Map<Path, Boolean> changeCache = new HashMap<Path, Boolean>();
    private final WatchService service;
    private final Map<Path, WatchKey> pathsObserved = new HashMap<Path, WatchKey>();

    private StaticPathWatcher() {
        try {
            this.service = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasFileChanged(Path filePath) {
        WatchKey key;
        if (!Files.exists(filePath, new LinkOption[0])) {
            return true;
        }
        while ((key = this.service.poll()) != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                Object ctx = event.context();
                if (!(ctx instanceof Path)) continue;
                Path path = (Path)ctx;
                this.changeCache.put(path.toAbsolutePath(), true);
            }
        }
        filePath = filePath.toAbsolutePath();
        Path parentPath = filePath.getParent();
        if (this.changeCache.containsKey(filePath)) {
            return true;
        }
        if (!this.pathsObserved.containsKey(parentPath)) {
            try {
                this.pathsObserved.put(parentPath, parentPath.register(this.service, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE));
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

