/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.fabricmc.loom.util.FileSystemUtil;
import org.jspecify.annotations.Nullable;

public class JarSplitter {
    private static final Attributes.Name MANIFEST_SPLIT_ENV_NAME = new Attributes.Name("Fabric-Loom-Split-Environment");
    private static final Attributes.Name MANIFEST_CLIENT_ENTRIES_NAME = new Attributes.Name("Fabric-Loom-Client-Only-Entries");
    final Path inputJar;

    public JarSplitter(Path inputJar) {
        this.inputJar = inputJar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public @Nullable Target analyseTarget() {
        try (FileSystemUtil.Delegate input = FileSystemUtil.getJarFileSystem(this.inputJar);){
            Manifest manifest = input.fromInputStream(Manifest::new, "META-INF/MANIFEST.MF", new String[0]);
            if (!Boolean.parseBoolean(manifest.getMainAttributes().getValue("Fabric-Loom-Split-Environment"))) {
                Target target = null;
                return target;
            }
            HashSet<String> clientEntries = new HashSet<String>(this.readClientEntries(manifest));
            if (clientEntries.isEmpty()) {
                Target target = Target.COMMON_ONLY;
                return target;
            }
            ArrayList<String> entries = new ArrayList<String>();
            try (Stream<Path> walk = Files.walk(input.get().getPath("/", new String[0]), new FileVisitOption[0]);){
                Iterator iterator = walk.iterator();
                while (iterator.hasNext()) {
                    Path relativePath;
                    Path entry = (Path)iterator.next();
                    if (!Files.isRegularFile(entry, new LinkOption[0]) || (relativePath = input.get().getPath("/", new String[0]).relativize(entry)).startsWith("META-INF") && (this.isSignatureData(relativePath) || relativePath.endsWith("MANIFEST.MF"))) continue;
                    entries.add(relativePath.toString());
                }
            }
            for (String entry : entries) {
                if (clientEntries.contains(entry)) continue;
                Target target = Target.SPLIT;
                return target;
            }
            Object object = Target.CLIENT_ONLY;
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read jar", e);
        }
    }

    public boolean split(Path commonOutputJar, Path clientOutputJar) throws IOException {
        Files.deleteIfExists(commonOutputJar);
        Files.deleteIfExists(clientOutputJar);
        try (FileSystemUtil.Delegate input = FileSystemUtil.getJarFileSystem(this.inputJar);){
            Manifest manifest = input.fromInputStream(Manifest::new, "META-INF/MANIFEST.MF", new String[0]);
            if (!Boolean.parseBoolean(manifest.getMainAttributes().getValue("Fabric-Loom-Split-Environment"))) {
                throw new UnsupportedOperationException("Cannot split jar that has not been built with a split env");
            }
            List<String> clientEntries = this.readClientEntries(manifest);
            if (clientEntries.isEmpty()) {
                throw new IllegalStateException("Expected to split jar with no client entries");
            }
            try (FileSystemUtil.Delegate commonOutput = FileSystemUtil.getJarFileSystem(commonOutputJar, true);
                 FileSystemUtil.Delegate clientOutput = FileSystemUtil.getJarFileSystem(clientOutputJar, true);
                 Stream<Path> walk = Files.walk(input.get().getPath("/", new String[0]), new FileVisitOption[0]);){
                Iterator iterator = walk.iterator();
                while (iterator.hasNext()) {
                    String entryPath;
                    Path relativePath;
                    Path entry = (Path)iterator.next();
                    if (!Files.isRegularFile(entry, new LinkOption[0]) || (relativePath = input.get().getPath("/", new String[0]).relativize(entry)).startsWith("META-INF") && this.isSignatureData(relativePath) || (entryPath = relativePath.toString()).equals("META-INF/MANIFEST.MF")) continue;
                    FileSystemUtil.Delegate target = clientEntries.contains(entryPath) ? clientOutput : commonOutput;
                    Path outputEntry = target.getPath(entryPath, new String[0]);
                    Path outputParent = outputEntry.getParent();
                    if (outputParent != null) {
                        Files.createDirectories(outputParent, new FileAttribute[0]);
                    }
                    Files.copy(entry, outputEntry, StandardCopyOption.COPY_ATTRIBUTES);
                }
                Manifest outManifest = new Manifest(manifest);
                Attributes attributes = outManifest.getMainAttributes();
                JarSplitter.stripSignatureData(outManifest);
                attributes.remove(Attributes.Name.SIGNATURE_VERSION);
                Objects.requireNonNull(attributes.remove(MANIFEST_SPLIT_ENV_NAME));
                Objects.requireNonNull(attributes.remove(MANIFEST_CLIENT_ENTRIES_NAME));
                JarSplitter.writeBytes(this.writeWithEnvironment(outManifest, "common"), commonOutput.getPath("META-INF/MANIFEST.MF", new String[0]));
                JarSplitter.writeBytes(this.writeWithEnvironment(outManifest, "client"), clientOutput.getPath("META-INF/MANIFEST.MF", new String[0]));
            }
        }
        return true;
    }

    private byte[] writeWithEnvironment(Manifest in, String value) throws IOException {
        Manifest manifest = new Manifest(in);
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Fabric-Loom-Split-Environment-Name", value);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        manifest.write(out);
        return out.toByteArray();
    }

    private List<String> readClientEntries(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String clientEntriesValue = attributes.getValue("Fabric-Loom-Client-Only-Entries");
        if (clientEntriesValue == null || clientEntriesValue.isBlank()) {
            return Collections.emptyList();
        }
        return Arrays.stream(clientEntriesValue.split(";")).toList();
    }

    private boolean isSignatureData(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.endsWith(".SF") || fileName.endsWith(".DSA") || fileName.endsWith(".RSA") || fileName.startsWith("SIG-");
    }

    private static void stripSignatureData(Manifest manifest) {
        Iterator<Attributes> it = manifest.getEntries().values().iterator();
        while (it.hasNext()) {
            Attributes attrs = it.next();
            Iterator<Object> it2 = attrs.keySet().iterator();
            while (it2.hasNext()) {
                Attributes.Name attrName = (Attributes.Name)it2.next();
                String name = attrName.toString();
                if (!name.endsWith("-Digest") && !name.contains("-Digest-") && !name.equals("Magic")) continue;
                it2.remove();
            }
            if (!attrs.isEmpty()) continue;
            it.remove();
        }
    }

    private static void writeBytes(byte[] bytes, Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.write(path, bytes, new OpenOption[0]);
    }

    public static enum Target {
        COMMON_ONLY(true, false),
        CLIENT_ONLY(false, true),
        SPLIT(true, true);

        final boolean common;
        final boolean client;

        private Target(boolean common, boolean client) {
            this.common = common;
            this.client = client;
        }

        public boolean common() {
            return this.common;
        }

        public boolean client() {
            return this.client;
        }
    }
}

