/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.gradle.SyncTaskBuildService;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GenVsCodeProjectTask
extends AbstractLoomTask {
    @ServiceReference(value="loomSyncTask")
    abstract Property<SyncTaskBuildService> getSyncTask();

    @Input
    protected abstract ListProperty<VsCodeConfiguration> getLaunchConfigurations();

    @OutputFile
    protected abstract RegularFileProperty getLaunchJson();

    @Inject
    public GenVsCodeProjectTask() {
        this.setGroup("ide");
        this.getLaunchConfigurations().set(this.getProject().provider(this::getConfigurations));
        this.getLaunchJson().convention(this.getProject().getIsolated().getRootProject().getProjectDirectory().file(".vscode/launch.json"));
    }

    private List<VsCodeConfiguration> getConfigurations() {
        ArrayList<VsCodeConfiguration> configurations = new ArrayList<VsCodeConfiguration>();
        for (RunConfigSettings settings : this.getExtension().getRunConfigs()) {
            if (!settings.isIdeConfigGenerated()) continue;
            VsCodeConfiguration configuration = VsCodeConfiguration.fromRunConfig(this.getProject(), RunConfig.runConfig(this.getProject(), settings));
            configurations.add(configuration);
        }
        return configurations;
    }

    @TaskAction
    public void genRuns() throws IOException {
        JsonArray configurations;
        JsonObject root;
        Path launchJson = ((RegularFile)this.getLaunchJson().get()).getAsFile().toPath();
        if (Files.notExists(launchJson.getParent(), new LinkOption[0])) {
            Files.createDirectories(launchJson.getParent(), new FileAttribute[0]);
        }
        if (Files.exists(launchJson, new LinkOption[0])) {
            root = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(launchJson, StandardCharsets.UTF_8), JsonObject.class);
        } else {
            root = new JsonObject();
            root.addProperty("version", "0.2.0");
        }
        if (root.has("configurations")) {
            configurations = root.getAsJsonArray("configurations");
        } else {
            configurations = new JsonArray();
            root.add("configurations", (JsonElement)configurations);
        }
        for (VsCodeConfiguration configuration : (List)this.getLaunchConfigurations().get()) {
            JsonObject configurationJson = LoomGradlePlugin.GSON.toJsonTree((Object)configuration).getAsJsonObject();
            configurationJson.remove("runDir");
            ArrayList<JsonElement> toRemove = new ArrayList<JsonElement>();
            for (JsonElement jsonElement : configurations) {
                JsonObject jsonObject;
                if (!jsonElement.isJsonObject() || !(jsonObject = jsonElement.getAsJsonObject()).has("name") || !jsonObject.get("name").getAsString().equalsIgnoreCase(configuration.name)) continue;
                toRemove.add(jsonElement);
            }
            toRemove.forEach(arg_0 -> ((JsonArray)configurations).remove(arg_0));
            configurations.add((JsonElement)configurationJson);
            Files.createDirectories(Paths.get(configuration.runDir, new String[0]), new FileAttribute[0]);
        }
        String json = LoomGradlePlugin.GSON.toJson((JsonElement)root);
        Files.writeString(launchJson, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public record VsCodeConfiguration(String type, String name, String request, String cwd, String console, boolean stopOnEntry, String mainClass, String vmArgs, String args, Map<String, Object> env, String projectName, String runDir) implements Serializable
    {
        public static VsCodeConfiguration fromRunConfig(Project project, RunConfig runConfig) {
            Path rootPath = project.getRootDir().toPath();
            Path projectPath = project.getProjectDir().toPath();
            String relativeRunDir = rootPath.relativize(projectPath).resolve(runConfig.runDir).toString();
            return new VsCodeConfiguration("java", runConfig.configName, "launch", "${workspaceFolder}/" + relativeRunDir, "integratedTerminal", false, runConfig.mainClass, RunConfig.joinArguments(runConfig.vmArgs), RunConfig.joinArguments(runConfig.programArgs), new HashMap<String, Object>(runConfig.environmentVariables), runConfig.projectName, rootPath.resolve(relativeRunDir).toAbsolutePath().toString());
        }
    }
}

