/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import java.nio.file.Path;
import net.fabricmc.loom.configuration.mods.ModConfigurationRemapper;
import net.fabricmc.loom.util.Checksum;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.jspecify.annotations.Nullable;

public interface ArtifactRef {
    public Path path();

    public @Nullable Path sources();

    public String name();

    public String group();

    public String version();

    public @Nullable String classifier();

    public void applyToConfiguration(Project var1, Configuration var2);

    public record FileArtifactRef(Path path, String group, String name, String version) implements ArtifactRef
    {
        @Override
        public @Nullable Path sources() {
            return null;
        }

        @Override
        public @Nullable String classifier() {
            return null;
        }

        @Override
        public void applyToConfiguration(Project project, Configuration configuration) {
            DependencyHandler dependencies = project.getDependencies();
            dependencies.add(configuration.getName(), (Object)project.files(new Object[]{this.path.toFile()}));
        }
    }

    public record ResolvedArtifactRef(ResolvedArtifact artifact, @Nullable Path sources) implements ArtifactRef
    {
        @Override
        public Path path() {
            return this.artifact.getFile().toPath();
        }

        @Override
        public String group() {
            return ModConfigurationRemapper.replaceIfNullOrEmpty(this.artifact.getModuleVersion().getId().getGroup(), () -> "unspecified");
        }

        @Override
        public String name() {
            return this.artifact.getModuleVersion().getId().getName();
        }

        @Override
        public String version() {
            return ModConfigurationRemapper.replaceIfNullOrEmpty(this.artifact.getModuleVersion().getId().getVersion(), () -> Checksum.of(this.artifact.getFile()).sha256().hex(10));
        }

        @Override
        public String classifier() {
            return this.artifact.getClassifier();
        }

        @Override
        public void applyToConfiguration(Project project, Configuration configuration) {
            DependencyHandler dependencies = project.getDependencies();
            Dependency dep = dependencies.create((Object)(String.valueOf(this.artifact.getModuleVersion()) + (String)(this.artifact.getClassifier() == null ? "" : ":" + this.artifact.getClassifier())));
            if (dep instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dep;
                moduleDependency.setTransitive(false);
            }
            dependencies.add(configuration.getName(), (Object)dep);
        }
    }
}

