/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.sandbox;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.util.Platform;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonUtils;

public sealed interface SandboxMetadata {
    public static final String SANDBOX_METADATA_FILENAME = "fabric-sandbox.json";

    public static SandboxMetadata readFromJar(Path path) {
        try {
            JsonObject jsonObject = ZipUtils.unpackGson(path, SANDBOX_METADATA_FILENAME, JsonObject.class);
            int version = FabricModJsonUtils.readInt(jsonObject, "version");
            switch (version) {
                case 1: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported sandbox metadata version: " + version);
                }
            }
            return V1.parseV1(jsonObject);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read: fabric-sandbox.json", e);
        }
    }

    public String mainClass();

    public boolean supportsPlatform(Platform var1);

    private static OperatingSystem parseOperatingSystem(String os) {
        return switch (os) {
            case "windows" -> OperatingSystem.WINDOWS;
            case "macos" -> OperatingSystem.MAC_OS;
            case "linux" -> OperatingSystem.LINUX;
            default -> throw new FabricModJsonUtils.ParseException("Unsupported sandbox operating system: %s", os);
        };
    }

    private static Architecture parseArchitecture(String arch) {
        return switch (arch) {
            case "x86_64" -> Architecture.X86_64;
            case "arm64" -> Architecture.ARM64;
            default -> throw new FabricModJsonUtils.ParseException("Unsupported sandbox architecture: %s", arch);
        };
    }

    public record V1(String mainClass, Map<OperatingSystem, List<Architecture>> supportedPlatforms) implements SandboxMetadata
    {
        static V1 parseV1(JsonObject jsonObject) {
            String mainClass = FabricModJsonUtils.readString(jsonObject, "mainClass");
            JsonObject platforms = FabricModJsonUtils.getJsonObject(jsonObject, "platforms");
            HashMap supportedPlatforms = new HashMap();
            for (Map.Entry entry : platforms.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonArray()) {
                    throw new FabricModJsonUtils.ParseException("Unexpected json array type for key (%s)", entry.getKey());
                }
                ArrayList<Architecture> architectures = new ArrayList<Architecture>();
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new FabricModJsonUtils.ParseException("Unexpected json primitive type for key (%s)", entry.getKey());
                    }
                    architectures.add(SandboxMetadata.parseArchitecture(element.getAsString()));
                }
                supportedPlatforms.put(SandboxMetadata.parseOperatingSystem((String)entry.getKey()), Collections.unmodifiableList(architectures));
            }
            return new V1(mainClass, Collections.unmodifiableMap(supportedPlatforms));
        }

        @Override
        public boolean supportsPlatform(Platform platform) {
            for (Map.Entry<OperatingSystem, List<Architecture>> entry : this.supportedPlatforms.entrySet()) {
                if (!entry.getKey().compatibleWith(platform)) continue;
                for (Architecture architecture : entry.getValue()) {
                    if (!architecture.compatibleWith(platform)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum OperatingSystem {
        WINDOWS,
        MAC_OS,
        LINUX;


        public boolean compatibleWith(Platform platform) {
            Platform.OperatingSystem operatingSystem = platform.getOperatingSystem();
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> operatingSystem.isWindows();
                case 1 -> operatingSystem.isMacOS();
                case 2 -> operatingSystem.isLinux();
            };
        }
    }

    public static enum Architecture {
        X86_64,
        ARM64;


        public boolean compatibleWith(Platform platform) {
            Platform.Architecture architecture = platform.getArchitecture();
            if (!architecture.is64Bit()) {
                return false;
            }
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (!architecture.isArm()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> architecture.isArm();
            };
        }
    }
}

