/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.loom.configuration.providers.minecraft.library.Library;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.artifacts.dsl.RepositoryHandler;

public abstract class LibraryProcessor {
    protected static final Predicate<Library> ALLOW_ALL = library -> true;
    protected final Platform platform;
    protected final LibraryContext context;

    public LibraryProcessor(Platform platform, LibraryContext context) {
        this.platform = Objects.requireNonNull(platform);
        this.context = Objects.requireNonNull(context);
    }

    public abstract ApplicationResult getApplicationResult();

    public Predicate<Library> apply(Consumer<Library> dependencyConsumer) {
        return ALLOW_ALL;
    }

    public void applyRepositories(RepositoryHandler repositories) {
    }

    public static enum ApplicationResult {
        MUST_APPLY,
        CAN_APPLY,
        DONT_APPLY;

    }
}

