/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.task.RemapJarTask;
import net.fabricmc.loom.task.service.ClientEntriesService;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.util.PatternFilterable;

public class MixinRefmapService
extends Service<Options> {
    public static final ServiceType<Options, MixinRefmapService> TYPE = new ServiceType<Options, MixinRefmapService>(Options.class, MixinRefmapService.class);

    public static Provider<List<Options>> createOptions(RemapJarTask task) {
        Project project = task.getProject();
        return project.provider(() -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            if (!((Boolean)extension.getMixin().getUseLegacyMixinAp().get()).booleanValue()) {
                return List.of();
            }
            MixinExtension mixinExtension = extension.getMixin();
            ArrayList<Provider<Options>> options = new ArrayList<Provider<Options>>();
            for (SourceSet sourceSet : mixinExtension.getMixinSourceSets()) {
                MixinExtension.MixinInformationContainer container = Objects.requireNonNull(MixinExtension.getMixinInformationContainer(sourceSet));
                List<String> rootPaths = ClientEntriesService.getRootPaths(sourceSet.getResources().getSrcDirs());
                String refmapName = (String)container.refmapNameProvider().get();
                List<String> mixinConfigs = container.sourceSet().getResources().matching((PatternFilterable)container.mixinConfigPattern()).getFiles().stream().map(ClientEntriesService.relativePath(rootPaths)).toList();
                options.add(MixinRefmapService.createOptions(project, mixinConfigs, refmapName));
            }
            return options.stream().map(Provider::get).toList();
        });
    }

    private static Provider<Options> createOptions(Project project, List<String> mixinConfigs, String refmapName) {
        return TYPE.create(project, (Action<Options>)((Action)o -> {
            o.getMixinConfigs().set((Iterable)mixinConfigs);
            o.getRefmapName().set((Object)refmapName);
        }));
    }

    public MixinRefmapService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public void applyToJar(Path path) throws IOException {
        FabricModJson fabricModJson = FabricModJsonFactory.createFromZipNullable(path);
        if (fabricModJson == null) {
            return;
        }
        List<String> allMixinConfigs = fabricModJson.getMixinConfigurations();
        List<String> mixinConfigs = ((List)((Options)this.getOptions()).getMixinConfigs().get()).stream().filter(allMixinConfigs::contains).toList();
        String refmapName = (String)((Options)this.getOptions()).getRefmapName().get();
        if (ZipUtils.contains(path, refmapName)) {
            int n = ZipUtils.transformJson(JsonObject.class, path, mixinConfigs.stream().collect(Collectors.toMap(s -> s, s -> json -> {
                if (!json.has("refmap")) {
                    json.addProperty("refmap", refmapName);
                }
                return json;
            })));
        }
    }

    public static interface Options
    extends Service.Options {
        @Input
        public ListProperty<String> getMixinConfigs();

        @Input
        public Property<String> getRefmapName();
    }
}

