/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide.idea;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.project.IsolatedProject;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class IdeaSyncTask
extends AbstractLoomTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeaSyncTask.class);

    @Nested
    protected abstract ListProperty<IntelijRunConfig> getIdeaRunConfigs();

    @Inject
    public IdeaSyncTask() {
        this.setGroup("ide");
        this.getIdeaRunConfigs().set(this.getProject().provider(this::getRunConfigs));
    }

    @TaskAction
    public void runTask() throws IOException {
        for (IntelijRunConfig config : (List)this.getIdeaRunConfigs().get()) {
            config.writeLaunchFile();
        }
    }

    private List<IntelijRunConfig> getRunConfigs() throws IOException {
        IsolatedProject rootProject = this.getProject().getIsolated().getRootProject();
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        String projectPath = this.getProject().getPath().equals(rootProject.getPath()) ? "" : this.getProject().getPath().replace(':', '_');
        File runConfigsDir = new File(rootProject.getProjectDirectory().file(".idea").getAsFile(), "runConfigurations");
        ArrayList<IntelijRunConfig> configs = new ArrayList<IntelijRunConfig>();
        for (RunConfigSettings settings : extension.getRunConfigs()) {
            if (!settings.isIdeConfigGenerated()) continue;
            RunConfig config = RunConfig.runConfig(this.getProject(), settings);
            String name = config.configName.replaceAll("[^a-zA-Z0-9$_]", "_");
            File runConfigFile = new File(runConfigsDir, name + projectPath + ".xml");
            String runConfigXml = config.fromDummy("idea_run_config_template.xml", true, this.getProject());
            List<String> excludedLibraryPaths = config.getExcludedLibraryPaths(this.getProject());
            IntelijRunConfig irc = (IntelijRunConfig)this.getProject().getObjects().newInstance(IntelijRunConfig.class, new Object[0]);
            irc.getRunConfigXml().set((Object)runConfigXml);
            irc.getExcludedLibraryPaths().set(excludedLibraryPaths);
            irc.getLaunchFile().set(runConfigFile);
            configs.add(irc);
            settings.makeRunDir();
        }
        return configs;
    }

    private static void setClasspathModifications(Path runConfig, List<String> exclusions) throws IOException {
        String outputXml;
        String inputXml = Files.readString(runConfig, StandardCharsets.UTF_8);
        try {
            outputXml = IdeaSyncTask.setClasspathModificationsInXml(inputXml, exclusions);
        }
        catch (Exception e) {
            LOGGER.error("Failed to modify idea xml", (Throwable)e);
            return;
        }
        if (!inputXml.equals(outputXml)) {
            Files.writeString(runConfig, (CharSequence)outputXml, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    @VisibleForTesting
    public static String setClasspathModificationsInXml(String input, List<String> exclusions) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(input)));
        Element root = document.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName("configuration");
        assert (nodeList.getLength() == 1);
        Element configuration = (Element)nodeList.item(0);
        NodeList classpathModificationsList = configuration.getElementsByTagName("classpathModifications");
        for (int i = 0; i < classpathModificationsList.getLength(); ++i) {
            configuration.removeChild(classpathModificationsList.item(i));
        }
        Element classpathModifications = document.createElement("classpathModifications");
        for (String exclusionPath : exclusions) {
            Element exclusion = document.createElement("entry");
            exclusion.setAttribute("exclude", "true");
            exclusion.setAttribute("path", exclusionPath);
            classpathModifications.appendChild(exclusion);
        }
        configuration.appendChild(classpathModifications);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        transformer.transform(source, new StreamResult(writer));
        return writer.toString().replace("\r", "");
    }

    public static interface IntelijRunConfig {
        @Input
        public Property<String> getRunConfigXml();

        @Input
        public ListProperty<String> getExcludedLibraryPaths();

        @OutputFile
        public RegularFileProperty getLaunchFile();

        default public void writeLaunchFile() throws IOException {
            Path launchFile = ((RegularFile)this.getLaunchFile().get()).getAsFile().toPath();
            if (Files.notExists(launchFile, new LinkOption[0])) {
                Files.createDirectories(launchFile.getParent(), new FileAttribute[0]);
                Files.writeString(launchFile, (CharSequence)this.getRunConfigXml().get(), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            try {
                IdeaSyncTask.setClasspathModifications(launchFile, (List)this.getExcludedLibraryPaths().get());
            }
            catch (Exception e) {
                LOGGER.error("Failed to modify run configuration xml", (Throwable)e);
            }
        }
    }
}

