/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.mappings.IntermediateMappingsService;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.tiny.MappingsMerger;
import net.fabricmc.loom.configuration.providers.mappings.tiny.TinyJarInfo;
import net.fabricmc.loom.configuration.providers.mappings.unpick.UnpickMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.stitch.Command;
import net.fabricmc.stitch.commands.CommandProposeFieldNames;
import org.apache.tools.ant.util.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingConfiguration.class);
    public final String mappingsIdentifier;
    private final Path mappingsWorkingDir;
    private final Path baseTinyMappings;
    public final Path tinyMappings;
    public final Path tinyMappingsJar;
    private final Path unpickDefinitions;
    private List<AnnotationsData> annotationsData = List.of();
    private @Nullable UnpickMetadata unpickMetadata;
    private Map<String, String> signatureFixes;

    private MappingConfiguration(String mappingsIdentifier, Path mappingsWorkingDir) {
        this.mappingsIdentifier = mappingsIdentifier;
        this.mappingsWorkingDir = mappingsWorkingDir;
        this.baseTinyMappings = mappingsWorkingDir.resolve("mappings-base.tiny");
        this.tinyMappings = mappingsWorkingDir.resolve("mappings.tiny");
        this.tinyMappingsJar = mappingsWorkingDir.resolve("mappings.jar");
        this.unpickDefinitions = mappingsWorkingDir.resolve("mappings.unpick");
    }

    public static MappingConfiguration create(Project project, ServiceFactory serviceFactory, DependencyInfo dependency, MinecraftProvider minecraftProvider) {
        String version = dependency.getResolvedVersion();
        Path inputJar = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve mappings: " + String.valueOf(dependency))).toPath();
        String mappingsName = StringUtils.removeSuffix((String)(dependency.getDependency().getGroup() + "." + dependency.getDependency().getName()), (String)"-unmerged");
        TinyJarInfo jarInfo = TinyJarInfo.get(inputJar);
        jarInfo.minecraftVersionId().ifPresent(id -> {
            if (!minecraftProvider.minecraftVersion().equals(id)) {
                LOGGER.warn("The mappings (%s) were not built for Minecraft version %s, proceed with caution.".formatted(dependency.getDepString(), minecraftProvider.minecraftVersion()));
            }
        });
        String mappingsIdentifier = MappingConfiguration.createMappingsIdentifier(mappingsName, version, MappingConfiguration.getMappingsClassifier(dependency, jarInfo.v2()), minecraftProvider.minecraftVersion());
        Path workingDir = minecraftProvider.dir(mappingsIdentifier).toPath();
        MappingConfiguration mappingProvider = new MappingConfiguration(mappingsIdentifier, workingDir);
        try {
            mappingProvider.setup(project, serviceFactory, minecraftProvider, inputJar);
        }
        catch (IOException e) {
            MappingConfiguration.cleanWorkingDirectory(workingDir);
            throw new UncheckedIOException("Failed to setup mappings: " + dependency.getDepString(), e);
        }
        return mappingProvider;
    }

    public Provider<TinyMappingsService.Options> getMappingsServiceOptions(Project project) {
        return TinyMappingsService.createOptions(project, Objects.requireNonNull(this.tinyMappings));
    }

    public TinyMappingsService getMappingsService(Project project, ServiceFactory serviceFactory) {
        return (TinyMappingsService)serviceFactory.get(this.getMappingsServiceOptions(project));
    }

    private void setup(Project project, ServiceFactory serviceFactory, MinecraftProvider minecraftProvider, Path inputJar) throws IOException {
        if (minecraftProvider.refreshDeps()) {
            MappingConfiguration.cleanWorkingDirectory(this.mappingsWorkingDir);
        }
        if (Files.notExists(this.tinyMappings, new LinkOption[0]) || minecraftProvider.refreshDeps()) {
            this.storeMappings(project, serviceFactory, minecraftProvider, inputJar);
        } else {
            try (FileSystem fileSystem = FileSystems.newFileSystem(inputJar, (ClassLoader)null);){
                this.extractExtras(fileSystem);
            }
        }
        if (Files.notExists(this.tinyMappingsJar, new LinkOption[0]) || minecraftProvider.refreshDeps()) {
            Files.deleteIfExists(this.tinyMappingsJar);
            ZipUtils.add(this.tinyMappingsJar, "mappings/mappings.tiny", Files.readAllBytes(this.tinyMappings));
        }
    }

    public void applyToProject(Project project, DependencyInfo dependency) {
        if (this.unpickMetadata != null && this.unpickMetadata.hasConstants()) {
            UnpickMetadata unpickMetadata = this.unpickMetadata;
            Objects.requireNonNull(unpickMetadata);
            UnpickMetadata unpickMetadata2 = unpickMetadata;
            int n = 0;
            String notation = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnpickMetadata.V1.class, UnpickMetadata.V2.class}, (Object)unpickMetadata2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    UnpickMetadata.V1 v1 = (UnpickMetadata.V1)unpickMetadata2;
                    yield String.format("%s:%s:%s:constants", dependency.getDependency().getGroup(), dependency.getDependency().getName(), dependency.getDependency().getVersion());
                }
                case 1 -> {
                    UnpickMetadata.V2 v2 = (UnpickMetadata.V2)unpickMetadata2;
                    yield Objects.requireNonNull(v2.constants());
                }
            };
            project.getDependencies().add("mappingsConstants", (Object)notation);
        }
        project.getDependencies().add("mappingsFinal", (Object)project.files(new Object[]{this.tinyMappingsJar.toFile()}));
    }

    private static String getMappingsClassifier(DependencyInfo dependency, boolean isV2) {
        String[] depStringSplit = dependency.getDepString().split(":");
        if (depStringSplit.length >= 4) {
            return "-" + depStringSplit[3] + (isV2 ? "-v2" : "");
        }
        return isV2 ? "-v2" : "";
    }

    private void storeMappings(Project project, ServiceFactory serviceFactory, MinecraftProvider minecraftProvider, Path inputJar) throws IOException {
        LOGGER.info(":extracting " + String.valueOf(inputJar.getFileName()));
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(inputJar);){
            MappingConfiguration.extractMappings(delegate.fs(), this.baseTinyMappings);
            this.extractExtras(delegate.fs());
        }
        if (MappingConfiguration.areMappingsV2(this.baseTinyMappings)) {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            if (((Boolean)extension.getUseIntermediateMappings().get()).booleanValue()) {
                IntermediateMappingsService intermediateMappingsService = (IntermediateMappingsService)serviceFactory.get(IntermediateMappingsService.createOptions(project, minecraftProvider));
                MappingsMerger.mergeAndSaveMappings(this.baseTinyMappings, this.tinyMappings, minecraftProvider, intermediateMappingsService);
            } else {
                Files.copy(this.baseTinyMappings, this.tinyMappings, StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            List<Path> minecraftJars = minecraftProvider.getMinecraftJars();
            if (minecraftJars.size() != 1) {
                throw new UnsupportedOperationException("V1 mappings only support single jar minecraft providers");
            }
            Files.deleteIfExists(this.tinyMappings);
            LOGGER.info(":populating field names");
            this.suggestFieldNames(minecraftJars.get(0), this.baseTinyMappings, this.tinyMappings);
        }
    }

    private static boolean areMappingsV2(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            boolean bl = MappingReader.detectFormat((Reader)reader) == MappingFormat.TINY_2_FILE;
            return bl;
        }
    }

    public static void extractMappings(Path jar, Path extractTo) throws IOException {
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(jar);){
            MappingConfiguration.extractMappings(delegate.fs(), extractTo);
        }
    }

    public static void extractMappings(FileSystem jar, Path extractTo) throws IOException {
        Files.copy(jar.getPath("mappings/mappings.tiny", new String[0]), extractTo, StandardCopyOption.REPLACE_EXISTING);
    }

    private void extractExtras(FileSystem jar) throws IOException {
        this.extractAnnotationsData(jar);
        this.extractUnpickDefinitions(jar);
        this.extractSignatureFixes(jar);
    }

    private void extractAnnotationsData(FileSystem jar) throws IOException {
        Path annotationsPath = jar.getPath("extras/annotations.json", new String[0]);
        if (!Files.exists(annotationsPath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(annotationsPath, StandardCharsets.UTF_8);){
            this.annotationsData = AnnotationsData.readList(reader);
        }
    }

    private void extractUnpickDefinitions(FileSystem jar) throws IOException {
        Path unpickPath = jar.getPath("extras/definitions.unpick", new String[0]);
        Path unpickMetadataPath = jar.getPath("extras/unpick.json", new String[0]);
        if (!Files.exists(unpickPath, new LinkOption[0]) || !Files.exists(unpickMetadataPath, new LinkOption[0])) {
            return;
        }
        Files.copy(unpickPath, this.unpickDefinitions, StandardCopyOption.REPLACE_EXISTING);
        this.unpickMetadata = UnpickMetadata.parse(unpickMetadataPath);
    }

    private void extractSignatureFixes(FileSystem jar) throws IOException {
        Path recordSignaturesJsonPath = jar.getPath("extras/record_signatures.json", new String[0]);
        if (!Files.exists(recordSignaturesJsonPath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(recordSignaturesJsonPath, StandardCharsets.UTF_8);){
            this.signatureFixes = (Map)LoomGradlePlugin.GSON.fromJson((Reader)reader, Map.class);
        }
    }

    private void suggestFieldNames(Path inputJar, Path oldMappings, Path newMappings) {
        CommandProposeFieldNames command = new CommandProposeFieldNames();
        this.runCommand((Command)command, inputJar.toFile().getAbsolutePath(), oldMappings.toAbsolutePath().toString(), newMappings.toAbsolutePath().toString());
    }

    private void runCommand(Command command, String ... args) {
        try {
            command.run(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void cleanWorkingDirectory(Path mappingsWorkingDir) {
        try {
            if (Files.exists(mappingsWorkingDir, new LinkOption[0])) {
                Files.walkFileTree(mappingsWorkingDir, new DeletingFileVisitor());
            }
            Files.createDirectories(mappingsWorkingDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Path mappingsWorkingDir() {
        return this.mappingsWorkingDir;
    }

    private static String createMappingsIdentifier(String mappingsName, String version, String classifier, String minecraftVersion) {
        return mappingsName + "." + minecraftVersion.replace(' ', '_').replace('.', '_').replace('-', '_') + "." + version + classifier;
    }

    public String mappingsIdentifier() {
        return this.mappingsIdentifier;
    }

    public File getUnpickDefinitionsFile() {
        return this.unpickDefinitions.toFile();
    }

    public boolean hasUnpickDefinitions() {
        return this.unpickMetadata != null;
    }

    public List<AnnotationsData> getAnnotationsData() {
        return this.annotationsData;
    }

    public UnpickMetadata getUnpickMetadata() {
        return Objects.requireNonNull(this.unpickMetadata, "Unpick metadata is not available");
    }

    public @Nullable Map<String, String> getSignatureFixes() {
        return this.signatureFixes;
    }
}

