/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import groovy.util.Node;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.DeprecationHelper;
import net.fabricmc.loom.util.GroovyXmlUtil;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;

public abstract class MavenPublication
implements Runnable {
    private static final Map<String, String> CONFIGURATION_TO_SCOPE = Map.of("apiElements", "compile", "runtimeElements", "runtime");
    private static final Set<Publication> EXCLUDED_PUBLICATIONS = Collections.newSetFromMap(new WeakHashMap());

    @Inject
    protected abstract Project getProject();

    @Override
    public void run() {
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), () -> {
            AtomicBoolean reportedDeprecation = new AtomicBoolean(false);
            CONFIGURATION_TO_SCOPE.forEach((configurationName, scope) -> {
                Configuration config = this.getProject().getConfigurations().getByName(configurationName);
                PublishingExtension mavenPublish = (PublishingExtension)this.getProject().getExtensions().findByType(PublishingExtension.class);
                if (mavenPublish != null) {
                    this.processEntry((String)scope, config, mavenPublish, reportedDeprecation);
                }
            });
        });
    }

    private static boolean hasSoftwareComponent(Publication publication) {
        try {
            Method getComponent = publication.getClass().getMethod("getComponent", new Class[0]);
            return getComponent.invoke((Object)publication, new Object[0]) != null;
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    private void processEntry(String scope, Configuration config, PublishingExtension mavenPublish, AtomicBoolean reportedDeprecation) {
        mavenPublish.publications(publications -> {
            for (Publication publication : publications) {
                if (!(publication instanceof org.gradle.api.publish.maven.MavenPublication)) continue;
                org.gradle.api.publish.maven.MavenPublication mavenPublication = (org.gradle.api.publish.maven.MavenPublication)publication;
                if (MavenPublication.hasSoftwareComponent(publication) || EXCLUDED_PUBLICATIONS.contains(publication)) continue;
                if (!reportedDeprecation.get()) {
                    DeprecationHelper deprecationHelper = LoomGradleExtension.get(this.getProject()).getDeprecationHelper();
                    deprecationHelper.warn("Loom is applying dependency data manually to publications instead of using a software component (from(components[\"java\"])). This is deprecated.");
                    reportedDeprecation.set(true);
                }
                mavenPublication.pom(pom -> pom.withXml(xml -> {
                    Node dependencies = GroovyXmlUtil.getOrCreateNode(xml.asNode(), "dependencies");
                    HashSet foundArtifacts = new HashSet();
                    GroovyXmlUtil.childrenNodesStream(dependencies).filter(n -> "dependency".equals(n.name())).forEach(n -> {
                        Optional<Node> groupId = GroovyXmlUtil.getNode(n, "groupId");
                        Optional<Node> artifactId = GroovyXmlUtil.getNode(n, "artifactId");
                        if (groupId.isPresent() && artifactId.isPresent()) {
                            foundArtifacts.add(groupId.get().text() + ":" + artifactId.get().text());
                        }
                    });
                    for (Dependency dependency : config.getAllDependencies()) {
                        Set exclusions;
                        if (foundArtifacts.contains(dependency.getGroup() + ":" + dependency.getName())) continue;
                        Node depNode = dependencies.appendNode((Object)"dependency");
                        depNode.appendNode((Object)"groupId", (Object)dependency.getGroup());
                        depNode.appendNode((Object)"artifactId", (Object)dependency.getName());
                        depNode.appendNode((Object)"version", (Object)dependency.getVersion());
                        depNode.appendNode((Object)"scope", (Object)scope);
                        if (!(dependency instanceof ModuleDependency) || (exclusions = ((ModuleDependency)dependency).getExcludeRules()).isEmpty()) continue;
                        Node exclusionsNode = depNode.appendNode((Object)"exclusions");
                        for (ExcludeRule rule : exclusions) {
                            Node exclusionNode = exclusionsNode.appendNode((Object)"exclusion");
                            exclusionNode.appendNode((Object)"groupId", (Object)(rule.getGroup() == null ? "*" : rule.getGroup()));
                            exclusionNode.appendNode((Object)"artifactId", (Object)(rule.getModule() == null ? "*" : rule.getModule()));
                        }
                    }
                }));
            }
        });
    }

    public static void excludePublication(Publication publication) {
        EXCLUDED_PUBLICATIONS.add(publication);
    }
}

