/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.task.service.MigrateMappingsService;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.lorenztiny.TinyMappingsJoiner;
import net.fabricmc.mappingio.tree.MappingTree;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.mixin.MixinRemapper;
import org.cadixdev.mercury.remapper.MercuryRemapper;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;

public final class MigrateSourceCodeMappingsService
extends Service<Options> {
    private static final ServiceType<Options, MigrateSourceCodeMappingsService> TYPE = new ServiceType<Options, MigrateSourceCodeMappingsService>(Options.class, MigrateSourceCodeMappingsService.class);

    public MigrateSourceCodeMappingsService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public static Provider<Options> createOptions(Project project, Provider<String> targetMappings, DirectoryProperty inputDir, DirectoryProperty outputDir) {
        JavaVersion javaVersion = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceCompatibility();
        return TYPE.create(project, (Action<Options>)((Action)o -> {
            o.getMappings().set(MigrateMappingsService.createOptions(project, targetMappings));
            o.getSourceCompatibility().set((Object)javaVersion.toString());
            o.getInputDir().set((Provider)inputDir);
            o.getOutputDir().set((Provider)outputDir);
        }));
    }

    public void migrateMappings() throws IOException {
        Path inputDir = ((Directory)((Options)this.getOptions()).getInputDir().get()).getAsFile().toPath();
        Path outputDir = ((Directory)((Options)this.getOptions()).getOutputDir().get()).getAsFile().toPath();
        if (!Files.exists(inputDir, new LinkOption[0]) || !Files.isDirectory(inputDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Could not find input directory: " + String.valueOf(inputDir.toAbsolutePath()));
        }
        if (Files.exists(outputDir, new LinkOption[0])) {
            DeletingFileVisitor.deleteDirectory(outputDir);
        }
        Files.createDirectories(outputDir, new FileAttribute[0]);
        Mercury mercury = new Mercury();
        mercury.setGracefulClasspathChecks(true);
        mercury.setSourceCompatibility((String)((Options)this.getOptions()).getSourceCompatibility().get());
        MigrateMappingsService migrateMappingsService = (MigrateMappingsService)this.getServiceFactory().get(((Options)this.getOptions()).getMappings());
        MappingsService sourceMappingsService = migrateMappingsService.getSourceMappingsService();
        TinyMappingsService targetMappingsService = migrateMappingsService.getTargetMappingsService();
        MappingSet mappingSet = new TinyMappingsJoiner((MappingTree)sourceMappingsService.getMemoryMappingTree(), MappingsNamespace.NAMED.toString(), (MappingTree)targetMappingsService.getMappingTree(), MappingsNamespace.NAMED.toString(), MappingsNamespace.INTERMEDIARY.toString()).read();
        mercury.getProcessors().add(MixinRemapper.create((MappingSet)mappingSet));
        mercury.getProcessors().add(MercuryRemapper.create((MappingSet)mappingSet));
        for (File file : migrateMappingsService.getClasspath().getFiles()) {
            mercury.getClassPath().add(file.toPath());
        }
        try {
            mercury.rewrite(inputDir, outputDir);
        }
        catch (Exception e) {
            try {
                DeletingFileVisitor.deleteDirectory(outputDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to migrate mappings", e);
        }
        System.gc();
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public Property<MigrateMappingsService.Options> getMappings();

        @InputDirectory
        public DirectoryProperty getInputDir();

        @Input
        public Property<String> getSourceCompatibility();

        @OutputDirectory
        public DirectoryProperty getOutputDir();
    }
}

