/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.unpick;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loom.LoomGradlePlugin;
import org.jspecify.annotations.Nullable;

public sealed interface UnpickMetadata {
    public static final String UNPICK_METADATA_PATH = "extras/unpick.json";
    public static final String UNPICK_DEFINITIONS_PATH = "extras/definitions.unpick";

    public boolean hasConstants();

    public static UnpickMetadata parse(Path path) throws IOException {
        JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(path, StandardCharsets.UTF_8), JsonObject.class);
        if (!jsonObject.has("version")) {
            throw new UnsupportedOperationException("Missing unpick metadata version");
        }
        int version = jsonObject.get("version").getAsInt();
        switch (version) {
            case 1: {
                return new V1(UnpickMetadata.getString(jsonObject, "unpickGroup"), UnpickMetadata.getString(jsonObject, "unpickVersion"));
            }
            case 2: {
                return new V2(UnpickMetadata.getString(jsonObject, "namespace"), UnpickMetadata.getOptionalString(jsonObject, "constants"));
            }
        }
        throw new UnsupportedOperationException("Unsupported unpick metadata version: %s. Please update loom.".formatted(version));
    }

    private static String getString(JsonObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            throw new UnsupportedOperationException("Missing unpick metadata %s".formatted(key));
        }
        return jsonObject.get(key).getAsString();
    }

    private static @Nullable String getOptionalString(JsonObject jsonObject, String key) {
        return jsonObject.has(key) ? jsonObject.get(key).getAsString() : null;
    }

    public record V1(@Deprecated String unpickGroup, @Deprecated String unpickVersion) implements UnpickMetadata
    {
        @Override
        public boolean hasConstants() {
            return true;
        }
    }

    public record V2(String namespace, @Nullable String constants) implements UnpickMetadata
    {
        @Override
        public boolean hasConstants() {
            return this.constants != null;
        }
    }
}

