/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import java.io.File;
import java.util.function.Consumer;
import net.fabricmc.loom.LoomGradleExtension;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;

public final class GradleUtils {
    private GradleUtils() {
    }

    public static void afterSuccessfulEvaluation(Project project, Runnable afterEvaluate) {
        project.afterEvaluate(p -> {
            if (p.getState().getFailure() != null) {
                return;
            }
            afterEvaluate.run();
        });
    }

    public static void allLoomProjects(Gradle gradle, Consumer<Project> consumer) {
        gradle.allprojects(project -> {
            if (GradleUtils.isLoomProject(project)) {
                consumer.accept((Project)project);
            }
        });
    }

    public static boolean isLoomProject(Project project) {
        return project.getPluginManager().hasPlugin("fabric-loom");
    }

    public static boolean isLoomCompanionProject(Project project) {
        return project.getPluginManager().hasPlugin("net.fabricmc.fabric-loom-companion");
    }

    public static Provider<Boolean> getBooleanPropertyProvider(Project project, String key) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.isProjectIsolationActive()) {
            return project.provider(() -> false);
        }
        return project.provider(() -> {
            Object value = project.findProperty(key);
            if (value instanceof String) {
                String str = (String)value;
                try {
                    return Boolean.parseBoolean(str);
                }
                catch (IllegalArgumentException ex) {
                    return false;
                }
            }
            return false;
        });
    }

    public static Provider<Integer> getIntegerPropertyProvider(Project project, String key) {
        return project.provider(() -> {
            Object value = project.findProperty(key);
            if (value == null) {
                return null;
            }
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Property " + key + " must be an integer", ex);
            }
        });
    }

    public static boolean getBooleanProperty(Project project, String key) {
        return GradleUtils.getBooleanProperty(project, key, false);
    }

    public static boolean getBooleanProperty(Project project, String key, boolean defaultValue) {
        return (Boolean)GradleUtils.getBooleanPropertyProvider(project, key).getOrElse((Object)defaultValue);
    }

    public static Object getProperty(Project project, String key) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.isProjectIsolationActive()) {
            return null;
        }
        return project.findProperty(key);
    }

    public static File configurationInputFile(Project project, File file) {
        RegularFileProperty property = project.getObjects().fileProperty();
        property.set(file);
        return (File)property.getAsFile().get();
    }

    public static boolean isRootProject(Project project) {
        return project.getRootProject() == project;
    }
}

