/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import groovy.namespace.QName;
import groovy.util.Node;
import java.util.Optional;
import java.util.stream.Stream;

public final class GroovyXmlUtil {
    private GroovyXmlUtil() {
    }

    public static Node getOrCreateNode(Node parent, String name) {
        for (Object object : parent.children()) {
            Node node;
            if (!(object instanceof Node) || !GroovyXmlUtil.isSameName((node = (Node)object).name(), name)) continue;
            return node;
        }
        return parent.appendNode((Object)name);
    }

    public static Optional<Node> getNode(Node parent, String name) {
        for (Object object : parent.children()) {
            Node node;
            if (!(object instanceof Node) || !GroovyXmlUtil.isSameName((node = (Node)object).name(), name)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    private static boolean isSameName(Object nodeName, String givenName) {
        if (nodeName instanceof String) {
            return nodeName.equals(givenName);
        }
        if (nodeName instanceof QName) {
            QName qName = (QName)nodeName;
            return qName.matches((Object)givenName);
        }
        throw new UnsupportedOperationException("Cannot determine if " + String.valueOf(nodeName.getClass()) + " is the same as a String");
    }

    public static Stream<Node> childrenNodesStream(Node node) {
        return node.children().stream().filter(i -> i instanceof Node);
    }
}

