/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import java.io.File;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.extension.LoomFiles;
import org.gradle.api.Project;

public abstract class LoomFilesBaseImpl
implements LoomFiles {
    protected abstract File getGradleUserHomeDir();

    protected abstract File getRootDir();

    protected abstract File getProjectDir();

    protected abstract File getBuildDir();

    private static File createFile(File parent, String child) {
        File file = new File(parent, child);
        file.mkdirs();
        return file;
    }

    @Override
    public File getUserCache() {
        return LoomFilesBaseImpl.createFile(this.getGradleUserHomeDir(), "caches" + File.separator + "fabric-loom");
    }

    @Override
    public File getRootProjectPersistentCache() {
        return LoomFilesBaseImpl.createFile(this.getRootDir(), ".gradle" + File.separator + "loom-cache");
    }

    @Override
    public File getProjectPersistentCache() {
        return LoomFilesBaseImpl.createFile(this.getProjectDir(), ".gradle" + File.separator + "loom-cache");
    }

    @Override
    public File getProjectBuildCache() {
        return LoomFilesBaseImpl.createFile(this.getBuildDir(), "loom-cache");
    }

    @Override
    public File getRemappedModCache() {
        return LoomFilesBaseImpl.createFile(this.getRootProjectPersistentCache(), "remapped_mods");
    }

    @Override
    public File getNativesDirectory(Project project) {
        return LoomFilesBaseImpl.createFile(this.getRootProjectPersistentCache(), "natives/" + LoomGradleExtension.get(project).getMinecraftProvider().minecraftVersion());
    }

    @Override
    public File getDefaultLog4jConfigFile() {
        return new File(this.getProjectPersistentCache(), "log4j.xml");
    }

    @Override
    public File getDevLauncherConfig() {
        return new File(this.getProjectPersistentCache(), "launch.cfg");
    }

    @Override
    public File getRemapClasspathFile() {
        return new File(this.getProjectPersistentCache(), "remapClasspath.txt");
    }

    @Override
    public File getGlobalMinecraftRepo() {
        return new File(this.getUserCache(), "minecraftMaven");
    }

    @Override
    public File getLocalMinecraftRepo() {
        return new File(this.getRootProjectPersistentCache(), "minecraftMaven");
    }

    @Override
    public File getDecompileCache(String version) {
        return new File(this.getUserCache(), "decompile/" + version + ".zip");
    }
}

