/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.mojmap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.loom.api.mappings.layered.MappingLayer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.intermediary.IntermediaryMappingLayer;
import net.fabricmc.loom.configuration.providers.mappings.utils.DstNameFilterMappingVisitor;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.proguard.ProGuardFileReader;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.logging.Logger;
import org.jspecify.annotations.Nullable;

public record MojangMappingLayer(Path clientMappings, Path serverMappings, boolean nameSyntheticMembers, boolean dropNoneIntermediaryRoots, @Nullable Supplier<MemoryMappingTree> intermediarySupplier, Logger logger) implements MappingLayer
{
    private static final Pattern SYNTHETIC_NAME_PATTERN = Pattern.compile("^(access|this|val\\$this|lambda\\$.*)\\$[0-9]+$");

    @Override
    public void visit(MappingVisitor mappingVisitor) throws IOException {
        this.printMappingsLicense(this.clientMappings);
        if (!this.dropNoneIntermediaryRoots) {
            this.logger().debug("Not attempting to drop none intermediary roots");
            this.readMappings(mappingVisitor);
            return;
        }
        this.logger().info("Attempting to drop none intermediary roots");
        if (this.intermediarySupplier == null) {
            this.readMappings(mappingVisitor);
            return;
        }
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        this.intermediarySupplier.get().accept((MappingVisitor)mappingTree);
        this.readMappings((MappingVisitor)mappingTree);
        MappingSourceNsSwitch officialSwitch = new MappingSourceNsSwitch(mappingVisitor, this.getSourceNamespace().toString(), false);
        MappingSourceNsSwitch intermediarySwitch = new MappingSourceNsSwitch((MappingVisitor)officialSwitch, MappingsNamespace.INTERMEDIARY.toString(), true);
        mappingTree.accept((MappingVisitor)intermediarySwitch);
    }

    private void readMappings(MappingVisitor mappingVisitor) throws IOException {
        DstNameFilterMappingVisitor nameFilter = new DstNameFilterMappingVisitor(mappingVisitor, SYNTHETIC_NAME_PATTERN);
        MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch((MappingVisitor)(this.nameSyntheticMembers() ? mappingVisitor : nameFilter), MappingsNamespace.OFFICIAL.toString());
        try (BufferedReader clientBufferedReader = Files.newBufferedReader(this.clientMappings, StandardCharsets.UTF_8);
             BufferedReader serverBufferedReader = Files.newBufferedReader(this.serverMappings, StandardCharsets.UTF_8);){
            ProGuardFileReader.read((Reader)clientBufferedReader, (String)MappingsNamespace.NAMED.toString(), (String)MappingsNamespace.OFFICIAL.toString(), (MappingVisitor)nsSwitch);
            ProGuardFileReader.read((Reader)serverBufferedReader, (String)MappingsNamespace.NAMED.toString(), (String)MappingsNamespace.OFFICIAL.toString(), (MappingVisitor)nsSwitch);
        }
    }

    private void printMappingsLicense(Path clientMappings) {
        try (BufferedReader clientBufferedReader = Files.newBufferedReader(clientMappings, StandardCharsets.UTF_8);){
            String line;
            this.logger().warn("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            this.logger().warn("Using of the official minecraft mappings is at your own risk!");
            this.logger().warn("Please make sure to read and understand the following license:");
            this.logger().warn("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            while ((line = clientBufferedReader.readLine()).startsWith("#")) {
                this.logger().warn(line);
            }
            this.logger().warn("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read client mappings", e);
        }
    }

    @Override
    public MappingsNamespace getSourceNamespace() {
        return MappingsNamespace.OFFICIAL;
    }

    @Override
    public List<Class<? extends MappingLayer>> dependsOn() {
        return List.of(IntermediaryMappingLayer.class);
    }
}

