/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftClassMerger {
    private static final String SIDE_DESCRIPTOR = "Lnet/fabricmc/api/EnvType;";
    private static final String ITF_DESCRIPTOR = "Lnet/fabricmc/api/EnvironmentInterface;";
    private static final String ITF_LIST_DESCRIPTOR = "Lnet/fabricmc/api/EnvironmentInterfaces;";
    private static final String SIDED_DESCRIPTOR = "Lnet/fabricmc/api/Environment;";
    private static final int PERMISSION_BITS = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger(MinecraftClassMerger.class);

    private static void visitSideAnnotation(AnnotationVisitor av, String side) {
        av.visitEnum("value", SIDE_DESCRIPTOR, side.toUpperCase(Locale.ROOT));
        av.visitEnd();
    }

    private static void visitItfAnnotation(AnnotationVisitor av, String side, List<String> itfDescriptors) {
        for (String itf : itfDescriptors) {
            AnnotationVisitor avItf = av.visitAnnotation(null, ITF_DESCRIPTOR);
            avItf.visitEnum("value", SIDE_DESCRIPTOR, side.toUpperCase(Locale.ROOT));
            avItf.visit("itf", (Object)Type.getType((String)("L" + itf + ";")));
            avItf.visitEnd();
        }
    }

    public byte[] merge(byte[] classClient, byte[] classServer) {
        ClassReader readerC = new ClassReader(classClient);
        ClassReader readerS = new ClassReader(classServer);
        ClassWriter writer = new ClassWriter(0);
        ClassNode nodeC = new ClassNode(589824);
        readerC.accept((ClassVisitor)nodeC, 0);
        ClassNode nodeS = new ClassNode(589824);
        readerS.accept((ClassVisitor)nodeS, 0);
        final ClassNode nodeOut = new ClassNode(589824);
        nodeOut.version = nodeC.version;
        nodeOut.access = nodeC.access;
        nodeOut.name = nodeC.name;
        nodeOut.signature = nodeC.signature;
        nodeOut.superName = nodeC.superName;
        nodeOut.sourceFile = nodeC.sourceFile;
        nodeOut.sourceDebug = nodeC.sourceDebug;
        nodeOut.outerClass = nodeC.outerClass;
        nodeOut.outerMethod = nodeC.outerMethod;
        nodeOut.outerMethodDesc = nodeC.outerMethodDesc;
        nodeOut.module = nodeC.module;
        nodeOut.nestHostClass = nodeC.nestHostClass;
        nodeOut.nestMembers = nodeC.nestMembers;
        nodeOut.attrs = nodeC.attrs;
        if (nodeC.invisibleAnnotations != null) {
            nodeOut.invisibleAnnotations = new ArrayList();
            nodeOut.invisibleAnnotations.addAll(nodeC.invisibleAnnotations);
        }
        if (nodeC.invisibleTypeAnnotations != null) {
            nodeOut.invisibleTypeAnnotations = new ArrayList();
            nodeOut.invisibleTypeAnnotations.addAll(nodeC.invisibleTypeAnnotations);
        }
        if (nodeC.visibleAnnotations != null) {
            nodeOut.visibleAnnotations = new ArrayList();
            nodeOut.visibleAnnotations.addAll(nodeC.visibleAnnotations);
        }
        if (nodeC.visibleTypeAnnotations != null) {
            nodeOut.visibleTypeAnnotations = new ArrayList();
            nodeOut.visibleTypeAnnotations.addAll(nodeC.visibleTypeAnnotations);
        }
        List<String> itfs = MinecraftClassMerger.mergePreserveOrder(nodeC.interfaces, nodeS.interfaces);
        nodeOut.interfaces = new ArrayList();
        ArrayList<String> clientItfs = new ArrayList<String>();
        ArrayList<String> serverItfs = new ArrayList<String>();
        for (String s : itfs) {
            boolean nc = nodeC.interfaces.contains(s);
            boolean ns = nodeS.interfaces.contains(s);
            nodeOut.interfaces.add(s);
            if (nc && !ns) {
                clientItfs.add(s);
                continue;
            }
            if (!ns || nc) continue;
            serverItfs.add(s);
        }
        if (!clientItfs.isEmpty() || !serverItfs.isEmpty()) {
            AnnotationVisitor envInterfaces = nodeOut.visitAnnotation(ITF_LIST_DESCRIPTOR, false);
            AnnotationVisitor eiArray = envInterfaces.visitArray("value");
            if (!clientItfs.isEmpty()) {
                MinecraftClassMerger.visitItfAnnotation(eiArray, "CLIENT", clientItfs);
            }
            if (!serverItfs.isEmpty()) {
                MinecraftClassMerger.visitItfAnnotation(eiArray, "SERVER", serverItfs);
            }
            eiArray.visitEnd();
            envInterfaces.visitEnd();
        }
        new Merger<InnerClassNode>(this, nodeC.innerClasses, nodeS.innerClasses){

            @Override
            public String getName(InnerClassNode entry) {
                return entry.name;
            }

            @Override
            public void applySide(InnerClassNode entry, String side) {
            }
        }.merge(nodeOut.innerClasses);
        new Merger<FieldNode>(this, nodeC.fields, nodeS.fields){

            @Override
            public String getName(FieldNode entry) {
                return entry.name + ";;" + entry.desc;
            }

            @Override
            public void applySide(FieldNode entry, String side) {
                AnnotationVisitor av = entry.visitAnnotation(MinecraftClassMerger.SIDED_DESCRIPTOR, false);
                MinecraftClassMerger.visitSideAnnotation(av, side);
            }

            @Override
            public FieldNode merge(FieldNode clientEntry, FieldNode serverEntry) {
                if (clientEntry.access == serverEntry.access) {
                    return super.merge(clientEntry, serverEntry);
                }
                LOGGER.debug("Field has different access modifiers: {}#{}{}, client: '{}', server: '{}'", new Object[]{nodeOut.name, clientEntry.name, clientEntry.desc, MinecraftClassMerger.formatMethodAccessFlags(clientEntry.access), MinecraftClassMerger.formatMethodAccessFlags(serverEntry.access)});
                clientEntry.access = MinecraftClassMerger.mergeAccess(clientEntry.access, serverEntry.access);
                return clientEntry;
            }
        }.merge(nodeOut.fields);
        new Merger<MethodNode>(this, nodeC.methods, nodeS.methods){

            @Override
            public String getName(MethodNode entry) {
                return entry.name + entry.desc;
            }

            @Override
            public void applySide(MethodNode entry, String side) {
                AnnotationVisitor av = entry.visitAnnotation(MinecraftClassMerger.SIDED_DESCRIPTOR, false);
                MinecraftClassMerger.visitSideAnnotation(av, side);
            }

            @Override
            public MethodNode merge(MethodNode clientEntry, MethodNode serverEntry) {
                if (clientEntry.access == serverEntry.access) {
                    return super.merge(clientEntry, serverEntry);
                }
                LOGGER.debug("Method has different access modifiers: {}#{}{}, client: '{}', server: '{}'", new Object[]{nodeOut.name, clientEntry.name, clientEntry.desc, MinecraftClassMerger.formatMethodAccessFlags(clientEntry.access), MinecraftClassMerger.formatMethodAccessFlags(serverEntry.access)});
                try {
                    clientEntry.access = MinecraftClassMerger.mergeAccess(clientEntry.access, serverEntry.access);
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("Failed to merge method %s#%s%s %s".formatted(nodeOut.name, clientEntry.name, clientEntry.desc, e.getMessage()), e);
                }
                return clientEntry;
            }
        }.merge(nodeOut.methods);
        nodeOut.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static List<String> mergePreserveOrder(List<String> first, List<String> second) {
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        int j = 0;
        while (i < first.size() || j < second.size()) {
            int saved = i + j;
            while (i < first.size() && j < second.size() && first.get(i).equals(second.get(j))) {
                out.add(first.get(i));
                ++i;
                ++j;
            }
            while (i < first.size() && !second.contains(first.get(i))) {
                out.add(first.get(i));
                ++i;
            }
            while (j < second.size() && !first.contains(second.get(j))) {
                out.add(second.get(j));
                ++j;
            }
            if (i + j != saved) continue;
            while (i < first.size()) {
                out.add(first.get(i));
                ++i;
            }
            while (j < second.size()) {
                if (!first.contains(second.get(j))) {
                    out.add(second.get(j));
                }
                ++j;
            }
        }
        return out;
    }

    @VisibleForTesting
    public static int mergeAccess(int clientAccess, int serverAccess) {
        MinecraftClassMerger.validateAccessMerge(clientAccess, serverAccess);
        if (MinecraftClassMerger.getAccessRating(clientAccess) > MinecraftClassMerger.getAccessRating(serverAccess)) {
            return serverAccess;
        }
        return clientAccess;
    }

    private static void validateAccessMerge(int clientAccess, int serverAccess) {
        int clientFlags = clientAccess & 0xFFFFFFF8;
        int serverFlags = serverAccess & 0xFFFFFFF8;
        if (clientFlags != serverFlags) {
            throw new IllegalStateException("Cannot merge methods with differing non-permission bits: client: %s server: %s".formatted(MinecraftClassMerger.formatMethodAccessFlags(clientAccess), MinecraftClassMerger.formatMethodAccessFlags(serverAccess)));
        }
    }

    private static int getAccessRating(int access) {
        if ((access & 1) != 0) {
            return 2;
        }
        if ((access & 4) != 0) {
            return 1;
        }
        return 0;
    }

    @VisibleForTesting
    public static String formatMethodAccessFlags(int access) {
        StringJoiner joiner = new StringJoiner(" ");
        if ((access & 1) != 0) {
            joiner.add("public");
        }
        if ((access & 2) != 0) {
            joiner.add("private");
        }
        if ((access & 4) != 0) {
            joiner.add("protected");
        }
        if ((access & 8) != 0) {
            joiner.add("static");
        }
        if ((access & 0x10) != 0) {
            joiner.add("final");
        }
        if ((access & 0x20) != 0) {
            joiner.add("synchronized");
        }
        if ((access & 0x40) != 0) {
            joiner.add("bridge");
        }
        if ((access & 0x80) != 0) {
            joiner.add("varargs");
        }
        if ((access & 0x100) != 0) {
            joiner.add("native");
        }
        if ((access & 0x400) != 0) {
            joiner.add("abstract");
        }
        if ((access & 0x800) != 0) {
            joiner.add("strictfp");
        }
        if ((access & 0x1000) != 0) {
            joiner.add("synthetic");
        }
        if ((access & 0x8000) != 0) {
            joiner.add("mandated");
        }
        return joiner.toString();
    }

    public static class SidedClassVisitor
    extends ClassVisitor {
        private final String side;

        public SidedClassVisitor(int api, ClassVisitor cv, String side) {
            super(api, cv);
            this.side = side;
        }

        public void visitEnd() {
            AnnotationVisitor av = this.cv.visitAnnotation(MinecraftClassMerger.SIDED_DESCRIPTOR, true);
            MinecraftClassMerger.visitSideAnnotation(av, this.side);
            super.visitEnd();
        }
    }

    private static abstract class Merger<T> {
        private final Map<String, T> entriesClient = new LinkedHashMap<String, T>();
        private final Map<String, T> entriesServer = new LinkedHashMap<String, T>();
        private final List<String> entryNames;

        Merger(List<T> entriesClient, List<T> entriesServer) {
            List<String> listClient = this.toMap(entriesClient, this.entriesClient);
            List<String> listServer = this.toMap(entriesServer, this.entriesServer);
            this.entryNames = MinecraftClassMerger.mergePreserveOrder(listClient, listServer);
        }

        public abstract String getName(T var1);

        public abstract void applySide(T var1, String var2);

        public T merge(T clientEntry, T serverEntry) {
            return clientEntry;
        }

        private List<String> toMap(List<T> entries, Map<String, T> map) {
            ArrayList<String> list = new ArrayList<String>(entries.size());
            for (T entry : entries) {
                String name = this.getName(entry);
                map.put(name, entry);
                list.add(name);
            }
            return list;
        }

        public void merge(List<T> list) {
            for (String s : this.entryNames) {
                T entryClient = this.entriesClient.get(s);
                T entryServer = this.entriesServer.get(s);
                if (entryClient != null && entryServer != null) {
                    list.add(this.merge(entryClient, entryServer));
                    continue;
                }
                if (entryClient != null) {
                    this.applySide(entryClient, "CLIENT");
                    list.add(entryClient);
                    continue;
                }
                this.applySide(entryServer, "SERVER");
                list.add(entryServer);
            }
        }
    }
}

