/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import net.fabricmc.loom.task.service.JarManifestService;
import net.fabricmc.loom.util.Check;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;

public class ManifestModificationAction
implements Action<Task>,
Serializable {
    private final Provider<JarManifestService> manifestService;
    private final String targetNamespace;
    private final Provider<Boolean> areEnvironmentSourceSetsSplit;
    private final Provider<List<String>> clientOnlyEntries;

    public ManifestModificationAction(Provider<JarManifestService> manifestService, String targetNamespace, Provider<Boolean> areEnvironmentSourceSetsSplit, Provider<List<String>> clientOnlyEntries) {
        this.manifestService = manifestService;
        this.targetNamespace = targetNamespace;
        this.areEnvironmentSourceSetsSplit = areEnvironmentSourceSetsSplit;
        this.clientOnlyEntries = clientOnlyEntries;
    }

    public void execute(@NotNull Task t) {
        Jar jarTask = (Jar)t;
        File jarFile = ((RegularFile)jarTask.getArchiveFile().get()).getAsFile();
        try {
            this.modifyManifest(jarFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to modify jar manifest for " + jarFile.getName(), e);
        }
    }

    private void modifyManifest(File jarFile) throws IOException {
        int count;
        HashMap<String, String> manifestAttributes = new HashMap<String, String>();
        manifestAttributes.put("Fabric-Mapping-Namespace", this.targetNamespace);
        if (((Boolean)this.areEnvironmentSourceSetsSplit.get()).booleanValue()) {
            manifestAttributes.put("Fabric-Loom-Split-Environment", "true");
        }
        if (this.clientOnlyEntries != null && !((List)this.clientOnlyEntries.get()).isEmpty()) {
            manifestAttributes.put("Fabric-Loom-Client-Only-Entries", String.join((CharSequence)";", (Iterable)this.clientOnlyEntries.get()));
        }
        Check.require((count = ZipUtils.transform(jarFile.toPath(), Map.of("META-INF/MANIFEST.MF", bytes -> {
            Manifest manifest = new Manifest(new ByteArrayInputStream((byte[])bytes));
            ((JarManifestService)this.manifestService.get()).apply(manifest, manifestAttributes);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            manifest.write(out);
            return out.toByteArray();
        }))) > 0, "Did not transform any jar manifest");
    }
}

