/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors.speccontext;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.configuration.processors.speccontext.ProjectView;
import net.fabricmc.loom.configuration.processors.speccontext.RemappedProjectView;
import net.fabricmc.loom.util.AsyncCache;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public record RemappedSpecContext(List<FabricModJson> modDependencies, List<FabricModJson> localMods, List<ModHolder> compileRuntimeMods) implements SpecContext
{
    public static RemappedSpecContext create(Project project) {
        return RemappedSpecContext.create(new RemappedProjectView.Impl(project));
    }

    @VisibleForTesting
    public static RemappedSpecContext create(RemappedProjectView projectView) {
        AsyncCache<List<FabricModJson>> fmjCache = new AsyncCache<List<FabricModJson>>();
        return new RemappedSpecContext(RemappedSpecContext.getDependentMods(projectView, fmjCache), projectView.getMods(), RemappedSpecContext.getCompileRuntimeMods(projectView, fmjCache));
    }

    private static List<FabricModJson> getDependentMods(RemappedProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList futures = new ArrayList();
        for (RemapConfigurationSettings entry : projectView.getRemapConfigurations()) {
            Set artifacts = ((Configuration)entry.getSourceConfiguration().get()).resolve();
            for (File artifact : artifacts) {
                futures.add(fmjCache.get(artifact.toPath().toAbsolutePath().toString(), () -> FabricModJsonFactory.createFromZipOptional(artifact.toPath()).map(List::of).orElseGet(List::of)));
            }
        }
        if (!projectView.disableProjectDependantMods()) {
            for (Project dependentProject : SpecContext.getDependentProjects(projectView).toList()) {
                futures.add(fmjCache.get(dependentProject.getPath(), () -> FabricModJsonHelpers.getModsInProject(dependentProject)));
            }
        }
        return SpecContext.distinctSorted(AsyncCache.joinList(futures));
    }

    private static List<ModHolder> getCompileRuntimeMods(RemappedProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList<ModHolder> mods = new ArrayList<ModHolder>(RemappedSpecContext.getCompileRuntimeModsFromRemapConfigs(projectView, fmjCache));
        for (Project dependentProject : RemappedSpecContext.getCompileRuntimeProjectDependencies(projectView).toList()) {
            List projectMods = fmjCache.getBlocking(dependentProject.getPath(), () -> FabricModJsonHelpers.getModsInProject(dependentProject));
            for (FabricModJson mod : projectMods) {
                mods.add(new ModHolder(mod));
            }
        }
        return Collections.unmodifiableList(mods);
    }

    private static List<ModHolder> getCompileRuntimeModsFromRemapConfigs(RemappedProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        Set<String> runtimeModIds = RemappedSpecContext.getModIds(ProjectView.ArtifactUsage.RUNTIME, projectView, fmjCache, projectView.getRuntimeRemapConfigurations().stream().filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get()));
        Set<String> commonRuntimeModIds = projectView.areEnvironmentSourceSetsSplit() ? RemappedSpecContext.getModIds(ProjectView.ArtifactUsage.RUNTIME, projectView, fmjCache, projectView.getRuntimeRemapConfigurations().stream().filter(settings -> (Boolean)settings.getSourceSet().map(sourceSet -> !sourceSet.getName().equals("client")).get()).filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get())) : null;
        Stream<FabricModJson> compileMods = RemappedSpecContext.getMods(ProjectView.ArtifactUsage.COMPILE, projectView, fmjCache, projectView.getCompileRemapConfigurations().stream().filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get()));
        return compileMods.filter(fabricModJson -> runtimeModIds.contains(fabricModJson.getId())).sorted(Comparator.comparing(FabricModJson::getId)).map(fabricModJson -> new ModHolder((FabricModJson)fabricModJson, commonRuntimeModIds == null || commonRuntimeModIds.contains(fabricModJson.getId()))).toList();
    }

    private static Stream<FabricModJson> getMods(ProjectView.ArtifactUsage artifactUsage, RemappedProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache, Stream<RemapConfigurationSettings> stream) {
        return stream.flatMap(projectView.resolveArtifacts(artifactUsage)).map(RemappedSpecContext.modFromZip(fmjCache)).filter(Objects::nonNull);
    }

    private static Set<String> getModIds(ProjectView.ArtifactUsage artifactUsage, RemappedProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache, Stream<RemapConfigurationSettings> stream) {
        return RemappedSpecContext.getMods(artifactUsage, projectView, fmjCache, stream).map(FabricModJson::getId).collect(Collectors.toSet());
    }

    private static Function<Path, @Nullable FabricModJson> modFromZip(AsyncCache<List<FabricModJson>> fmjCache) {
        return zipPath -> {
            List list = fmjCache.getBlocking(zipPath.toAbsolutePath().toString(), () -> FabricModJsonFactory.createFromZipOptional(zipPath).map(List::of).orElseGet(List::of));
            return list.isEmpty() ? null : (FabricModJson)list.getFirst();
        };
    }

    private static Stream<Project> getCompileRuntimeProjectDependencies(ProjectView projectView) {
        if (projectView.disableProjectDependantMods()) {
            return Stream.empty();
        }
        Stream<Project> runtimeProjects = projectView.getLoomProjectDependencies("runtimeClasspath");
        List<Project> compileProjects = projectView.getLoomProjectDependencies("compileClasspath").toList();
        return runtimeProjects.filter(compileProjects::contains);
    }

    @Override
    public List<FabricModJson> modDependenciesCompileRuntime() {
        return this.compileRuntimeMods.stream().map(ModHolder::mod).toList();
    }

    @Override
    public List<FabricModJson> modDependenciesCompileRuntimeClient() {
        return this.compileRuntimeMods.stream().filter(modHolder -> !modHolder.common()).map(ModHolder::mod).toList();
    }

    private record ModHolder(FabricModJson mod, boolean common) {
        ModHolder(FabricModJson mod) {
            this(mod, true);
        }
    }
}

