/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.configuration.processors.speccontext.DebofConfiguration;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebofInstallerData {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebofInstallerData.class);

    public static void findAndApply(Project project) {
        for (DebofConfiguration debofConfiguration : DebofConfiguration.ALL) {
            for (Configuration configuration : debofConfiguration.getConfigurations(project)) {
                Optional<InstallerData> installerData = configuration.getFiles().parallelStream().map(DebofInstallerData::getInstaller).filter(Objects::nonNull).findFirst();
                if (!installerData.isPresent()) continue;
                LOGGER.info("Applying installer data from configuration '{}'", (Object)configuration.getName());
                installerData.get().applyToProject(project);
                return;
            }
        }
        LOGGER.info("No installer data found in any configuration.");
    }

    @Nullable
    private static InstallerData getInstaller(File file) {
        try {
            byte[] installerData = ZipUtils.unpackNullable(file.toPath(), "fabric-installer.json");
            if (installerData == null) {
                return null;
            }
            FabricModJson fabricModJson = FabricModJsonFactory.createFromZip(file.toPath());
            LOGGER.info("Found installer in mod {} version {}", (Object)fabricModJson.getId(), (Object)fabricModJson.getModVersion());
            return InstallerData.fromBytes(installerData, fabricModJson.getModVersion());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + String.valueOf(file), e);
        }
    }
}

