/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import net.fabricmc.loom.build.nesting.JarNester;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class NestJarsAction
implements Action<Task>,
Serializable {
    private final FileCollection jars;

    public NestJarsAction(FileCollection jars) {
        this.jars = jars;
    }

    public void execute(@NotNull Task t) {
        Jar jarTask = (Jar)t;
        File jarFile = ((RegularFile)jarTask.getArchiveFile().get()).getAsFile();
        ArrayList<File> allJars = new ArrayList<File>(this.jars.getFiles());
        if (!allJars.isEmpty()) {
            JarNester.nestJars(allJars, jarFile, (Logger)jarTask.getLogger());
            jarTask.getLogger().lifecycle("Nested {} jar(s) into {}", new Object[]{allJars.size(), jarFile.getName()});
        }
    }
}

