/*
 * This file is part of fabric-loom, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2025 FabricMC
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package net.fabricmc.loom.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import org.slf4j.Logger;

public class SLF4JAdapterHandler extends Handler {
	private final Logger logger;
	private final boolean suppressWarnings;

	public SLF4JAdapterHandler(Logger logger, boolean suppressWarnings) {
		this.logger = logger;
		this.suppressWarnings = suppressWarnings;
	}

	@Override
	public void publish(LogRecord record) {
		if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
			logger.error(record.getMessage(), record.getThrown());
		} else if (record.getLevel().intValue() >= Level.WARNING.intValue() && !suppressWarnings) {
			logger.warn(record.getMessage(), record.getThrown());
		} else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
			logger.info(record.getMessage(), record.getThrown());
		} else if (record.getLevel().intValue() >= Level.FINER.intValue()) {
			logger.debug(record.getMessage(), record.getThrown());
		} else {
			logger.trace(record.getMessage(), record.getThrown());
		}
	}

	@Override
	public void flush() {
	}

	@Override
	public void close() throws SecurityException {
	}
}
