/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.nesting.NestableJarGenerationTask;
import net.fabricmc.loom.task.ManifestModificationAction;
import net.fabricmc.loom.task.NestJarsAction;
import net.fabricmc.loom.task.service.ClientEntriesService;
import net.fabricmc.loom.task.service.JarManifestService;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;

public class NonRemappedJarTaskConfiguration {
    private final Project project;
    private final LoomGradleExtension extension;
    private final TaskProvider<NestableJarGenerationTask> processIncludeJarsTask;

    public NonRemappedJarTaskConfiguration(Project project, LoomGradleExtension extension, TaskProvider<NestableJarGenerationTask> processIncludeJarsTask) {
        this.project = project;
        this.extension = extension;
        this.processIncludeJarsTask = processIncludeJarsTask;
    }

    public void configure() {
        Provider<JarManifestService> manifestServiceProvider = JarManifestService.get(this.project);
        this.project.getTasks().named("jar", Jar.class).configure(task -> {
            task.dependsOn(new Object[]{this.processIncludeJarsTask});
            task.doLast((Action)new NestJarsAction((FileCollection)this.project.fileTree((Object)this.processIncludeJarsTask.flatMap(NestableJarGenerationTask::getOutputDirectory)).matching(pattern -> pattern.include(new String[]{"*.jar"}))));
            task.doLast((Action)new ManifestModificationAction(manifestServiceProvider, "official", (Provider<Boolean>)this.project.provider(this.extension::areEnvironmentSourceSetsSplit), (Provider<List<String>>)this.project.provider(this::getClientOnlyEntries)));
            task.usesService(manifestServiceProvider);
        });
        this.extension.getUnmappedModCollection().from(new Object[]{this.project.getTasks().getByName("jar")});
    }

    private List<String> getClientOnlyEntries() {
        ArrayList<String> arrayList;
        if (!this.extension.areEnvironmentSourceSetsSplit()) {
            return Collections.emptyList();
        }
        SourceSet clientSourceSet = SourceSetHelper.getSourceSetByName("client", this.project);
        Provider<ClientEntriesService.Classes.Options> optionsProvider = ClientEntriesService.Classes.createOptions(this.project, clientSourceSet);
        ScopedServiceFactory serviceFactory = new ScopedServiceFactory();
        try {
            ClientEntriesService service = (ClientEntriesService)serviceFactory.get(optionsProvider);
            arrayList = new ArrayList<String>(service.getClientOnlyEntries());
        }
        catch (Throwable throwable) {
            try {
                try {
                    serviceFactory.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to determine client-only entries", e);
            }
        }
        serviceFactory.close();
        return arrayList;
    }
}

