/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.OutputStream;
import java.util.function.Consumer;

public class ConsumingOutputStream
extends OutputStream {
    private final Consumer<String> consumer;
    private StringBuilder buffer = new StringBuilder();

    public ConsumingOutputStream(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void write(int b) {
        char ch = (char)(b & 0xFF);
        this.buffer.append(ch);
        if (ch == '\n' || ch == '\r') {
            this.flush();
        }
    }

    @Override
    public void flush() {
        String str = this.buffer.toString();
        if (str.endsWith("\r") || str.endsWith("\n")) {
            if (!(str = str.trim()).isEmpty()) {
                this.consumer.accept(str);
            }
            this.buffer = new StringBuilder();
        }
    }
}

