/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency.refmap;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import net.fabricmc.loom.configuration.mods.dependency.refmap.MixinReferenceRemapper;
import net.fabricmc.loom.configuration.mods.dependency.refmap.MixinReferenceRemapperImpl;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.fmj.mixin.MixinConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixinRefmapInliner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MixinRefmapInliner.class);

    public static MixinReferenceRemapper createRemapper(String from, String to, List<ModDependency> mods) throws IOException {
        ArrayList<MixinConfiguration> mixinConfigurations = new ArrayList<MixinConfiguration>();
        for (ModDependency mod : mods) {
            if (mod.getMetadata().mixinRemapType() != ArtifactMetadata.MixinRemapType.MIXIN) continue;
            FabricModJson fabricModJson = FabricModJsonFactory.createFromZipNullable(mod.getInputFile());
            if (fabricModJson == null) {
                LOGGER.warn("Failed to read fabric.mod.json from {}", (Object)mod.getInputFile());
                continue;
            }
            try {
                mixinConfigurations.addAll(MixinConfiguration.fromMod(fabricModJson));
            }
            catch (IOException e) {
                throw ExceptionUtil.createDescriptiveWrapper(IOException::new, "Failed to read mixin configuration from " + String.valueOf(mod.getInputFile()), e);
            }
        }
        return MixinReferenceRemapperImpl.createFromRefmaps(from, to, mixinConfigurations.stream().map(MixinConfiguration::refmap));
    }

    public static void removeRefmap(ModDependency modDependency, Path ouputPath) {
    }
}

