/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.AnnotationNode;

class AnnotationNodeSerializer
implements JsonSerializer<AnnotationNode>,
JsonDeserializer<AnnotationNode> {
    AnnotationNodeSerializer() {
    }

    public AnnotationNode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String desc = jsonObject.getAsJsonPrimitive("desc").getAsString();
        AnnotationNode annotation = new AnnotationNode(desc);
        JsonObject values = jsonObject.getAsJsonObject("values");
        if (values != null) {
            for (Map.Entry entry : values.entrySet()) {
                AnnotationNodeSerializer.deserializeAnnotationValue((AnnotationVisitor)annotation, (String)entry.getKey(), (JsonElement)entry.getValue(), context);
            }
        }
        return annotation;
    }

    private static void deserializeAnnotationValue(AnnotationVisitor visitor, @Nullable String name, JsonElement value, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = value.getAsJsonObject();
        switch (obj.getAsJsonPrimitive("type").getAsString()) {
            case "byte": {
                visitor.visit(name, (Object)obj.getAsJsonPrimitive("value").getAsByte());
                break;
            }
            case "boolean": {
                visitor.visit(name, (Object)obj.getAsJsonPrimitive("value").getAsBoolean());
                break;
            }
            case "char": {
                visitor.visit(name, (Object)Character.valueOf(obj.getAsJsonPrimitive("value").getAsString().charAt(0)));
                break;
            }
            case "short": {
                visitor.visit(name, (Object)obj.getAsJsonPrimitive("value").getAsShort());
                break;
            }
            case "int": {
                visitor.visit(name, (Object)obj.getAsJsonPrimitive("value").getAsInt());
                break;
            }
            case "long": {
                visitor.visit(name, (Object)obj.getAsJsonPrimitive("value").getAsLong());
                break;
            }
            case "float": {
                visitor.visit(name, (Object)Float.valueOf(obj.getAsJsonPrimitive("value").getAsFloat()));
                break;
            }
            case "double": {
                visitor.visit(name, (Object)obj.getAsJsonPrimitive("value").getAsDouble());
                break;
            }
            case "string": {
                visitor.visit(name, (Object)obj.getAsJsonPrimitive("value").getAsString());
                break;
            }
            case "class": {
                visitor.visit(name, (Object)org.objectweb.asm.Type.getType((String)obj.getAsJsonPrimitive("value").getAsString()));
                break;
            }
            case "enum_constant": {
                visitor.visitEnum(name, obj.getAsJsonPrimitive("owner").getAsString(), obj.getAsJsonPrimitive("name").getAsString());
                break;
            }
            case "annotation": {
                AnnotationNode annotation = (AnnotationNode)context.deserialize((JsonElement)obj, AnnotationNode.class);
                AnnotationVisitor av = visitor.visitAnnotation(name, annotation.desc);
                if (av == null) break;
                annotation.accept(av);
                break;
            }
            case "array": {
                AnnotationVisitor av = visitor.visitArray(name);
                if (av == null) break;
                for (JsonElement element : obj.getAsJsonArray("value")) {
                    AnnotationNodeSerializer.deserializeAnnotationValue(av, null, element, context);
                }
                av.visitEnd();
            }
        }
    }

    public JsonElement serialize(AnnotationNode src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("desc", src.desc);
        if (src.values != null && !src.values.isEmpty()) {
            JsonObject values = new JsonObject();
            for (int i = 0; i < src.values.size() - 1; i += 2) {
                String name = String.valueOf(src.values.get(i));
                Object value = src.values.get(i + 1);
                values.add(name, (JsonElement)AnnotationNodeSerializer.serializeAnnotationValue(value, context));
            }
            json.add("values", (JsonElement)values);
        }
        return json;
    }

    private static JsonObject serializeAnnotationValue(Object value, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Boolean.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, org.objectweb.asm.Type.class, String[].class, AnnotationNode.class, List.class}, (Object)object2, n)) {
            case 0: {
                Byte b = (Byte)object2;
                json.addProperty("type", "byte");
                json.addProperty("value", (Number)b);
                break;
            }
            case 1: {
                Boolean b = (Boolean)object2;
                json.addProperty("type", "boolean");
                json.addProperty("value", b);
                break;
            }
            case 2: {
                Character c = (Character)object2;
                json.addProperty("type", "char");
                json.addProperty("value", c);
                break;
            }
            case 3: {
                Short s = (Short)object2;
                json.addProperty("type", "short");
                json.addProperty("value", (Number)s);
                break;
            }
            case 4: {
                Integer i = (Integer)object2;
                json.addProperty("type", "int");
                json.addProperty("value", (Number)i);
                break;
            }
            case 5: {
                Long l = (Long)object2;
                json.addProperty("type", "long");
                json.addProperty("value", (Number)l);
                break;
            }
            case 6: {
                Float f = (Float)object2;
                json.addProperty("type", "float");
                json.addProperty("value", (Number)f);
                break;
            }
            case 7: {
                Double d = (Double)object2;
                json.addProperty("type", "double");
                json.addProperty("value", (Number)d);
                break;
            }
            case 8: {
                String str = (String)object2;
                json.addProperty("type", "string");
                json.addProperty("value", str);
                break;
            }
            case 9: {
                org.objectweb.asm.Type type = (org.objectweb.asm.Type)object2;
                json.addProperty("type", "class");
                json.addProperty("value", type.getDescriptor());
                break;
            }
            case 10: {
                String[] enumConstant = (String[])object2;
                json.addProperty("type", "enum_constant");
                json.addProperty("owner", enumConstant[0]);
                json.addProperty("name", enumConstant[1]);
                break;
            }
            case 11: {
                AnnotationNode annotation = (AnnotationNode)object2;
                json.addProperty("type", "annotation");
                JsonObject annJson = context.serialize((Object)annotation).getAsJsonObject();
                json.asMap().putAll(annJson.asMap());
                break;
            }
            case 12: {
                List list = (List)object2;
                json.addProperty("type", "array");
                JsonArray array = new JsonArray(list.size());
                for (Object o : list) {
                    array.add((JsonElement)AnnotationNodeSerializer.serializeAnnotationValue(o, context));
                }
                json.add("value", (JsonElement)array);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown annotation value type: " + String.valueOf(value));
            }
        }
        return json;
    }
}

