/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.service.MigrateMappingsService;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;

@UntrackedTask(because="Always rerun this task.")
public abstract class MigrateMappingsTask
extends AbstractLoomTask {
    @Input
    @Option(option="mappings", description="Target mappings")
    public abstract Property<String> getMappings();

    @InputDirectory
    @SkipWhenEmpty
    @Option(option="input", description="Java source file directory")
    public abstract DirectoryProperty getInputDir();

    @OutputDirectory
    @Option(option="output", description="Remapped source output directory")
    public abstract DirectoryProperty getOutputDir();

    @Input
    @Option(option="overrideInputsIHaveABackup", description="Override input files with the remapped files")
    public abstract Property<Boolean> getOverrideInputs();

    @Nested
    protected abstract Property<MigrateMappingsService.Options> getMigrationServiceOptions();

    public MigrateMappingsTask() {
        this.getInputDir().convention(this.getProject().getLayout().getProjectDirectory().dir("src/main/java"));
        this.getOutputDir().convention(this.getProject().getLayout().getProjectDirectory().dir("remappedSrc"));
        this.getMigrationServiceOptions().set(MigrateMappingsService.createOptions(this.getProject(), this.getMappings(), this.getInputDir(), this.getOutputDir()));
        this.getOverrideInputs().convention((Object)false);
    }

    @TaskAction
    public void doTask() throws Throwable {
        try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            MigrateMappingsService service = (MigrateMappingsService)serviceFactory.get((MigrateMappingsService.Options)this.getMigrationServiceOptions().get());
            service.migrateMapppings();
        }
        if (((Boolean)this.getOverrideInputs().get()).booleanValue()) {
            Path inputPath = ((File)this.getInputDir().getAsFile().get()).toPath();
            Path outputPath = ((File)this.getOutputDir().getAsFile().get()).toPath();
            DeletingFileVisitor.deleteDirectory(inputPath);
            Files.move(outputPath, inputPath, new CopyOption[0]);
        }
    }
}

