/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj.mixin;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonSource;
import net.fabricmc.loom.util.fmj.mixin.MixinRefmap;
import org.jetbrains.annotations.Nullable;

public record MixinConfiguration(@Nullable MixinRefmap refmap) {
    private static final String REFMAP_KEY = "refmap";

    public static List<MixinConfiguration> fromMod(FabricModJson fabricModJson) throws IOException {
        ArrayList<MixinConfiguration> configs = new ArrayList<MixinConfiguration>();
        for (String configPath : fabricModJson.getMixinConfigurations()) {
            configs.add(MixinConfiguration.fromMod(configPath, fabricModJson.getSource()));
        }
        return configs;
    }

    private static MixinConfiguration fromMod(String configPath, FabricModJsonSource modSource) throws IOException {
        String mixinConfigJson = new String(modSource.read(configPath));
        JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(mixinConfigJson, JsonObject.class);
        MixinRefmap refmap = null;
        if (jsonObject.has(REFMAP_KEY)) {
            String refmapPath = jsonObject.get(REFMAP_KEY).getAsString();
            refmap = MixinRefmap.fromMod(refmapPath, modSource);
        }
        return new MixinConfiguration(refmap);
    }
}

