/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loom.api.MixinExtensionAPI;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface MixinExtension
extends MixinExtensionAPI {
    public static final String MIXIN_INFORMATION_CONTAINER = "mixin";

    @Nullable
    public static MixinInformationContainer getMixinInformationContainer(SourceSet sourceSet) {
        ExtraPropertiesExtension extra = sourceSet.getExtensions().getExtraProperties();
        return extra.has(MIXIN_INFORMATION_CONTAINER) ? (MixinInformationContainer)extra.get(MIXIN_INFORMATION_CONTAINER) : null;
    }

    public static void setMixinInformationContainer(SourceSet sourceSet, MixinInformationContainer container) {
        ExtraPropertiesExtension extra = sourceSet.getExtensions().getExtraProperties();
        if (extra.has(MIXIN_INFORMATION_CONTAINER)) {
            throw new InvalidUserDataException("The sourceSet " + sourceSet.getName() + " has been configured for mixin annotation processor multiple times");
        }
        extra.set(MIXIN_INFORMATION_CONTAINER, (Object)container);
    }

    @NotNull
    public Stream<SourceSet> getMixinSourceSetsStream();

    @NotNull
    public Stream<Configuration> getApConfigurationsStream(Function<SourceSet, String> var1);

    @NotNull
    public <T extends Task> Stream<Map.Entry<SourceSet, TaskProvider<T>>> getInvokerTasksStream(String var1, Class<T> var2);

    @Input
    @NotNull
    public Collection<SourceSet> getMixinSourceSets();

    public void init();

    public Property<Boolean> getInlineDependencyRefmaps();

    public record MixinInformationContainer(SourceSet sourceSet, Provider<String> refmapNameProvider, PatternSet mixinConfigPattern) {
    }
}

